/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionsTopHitProvider
implements SearchTopHitProvider {
    @NotNull
    public abstract Collection<OptionDescription> getOptions(@Nullable Project var1);

    public final void consumeTopHits(@NonNls String pattern, Consumer<Object> collector, Project project2) {
        if (!pattern.startsWith("#")) {
            return;
        }
        List parts = StringUtil.split((String)(pattern = pattern.substring(1)), (String)" ");
        if (parts.size() == 0) {
            return;
        }
        String id = (String)parts.get(0);
        if (this.getId().startsWith(id) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : pattern.substring(id.length()).trim().toLowerCase();
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            for (OptionDescription option : this.getOptions(project2)) {
                if (!matcher.matches(option.getOption())) continue;
                collector.consume((Object)option);
            }
        }
    }

    public abstract String getId();

    public boolean isEnabled(@Nullable Project project2) {
        return true;
    }

    static String messageApp(String property) {
        return StringUtil.stripHtml((String)ApplicationBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageIde(String property) {
        return StringUtil.stripHtml((String)IdeBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageKeyMap(String property) {
        return StringUtil.stripHtml((String)KeyMapBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

