/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class DarculaTextBorder
implements Border,
UIResource,
ErrorBorderCapable {
    @Override
    public Insets getBorderInsets(Component c) {
        int vOffset;
        int n = vOffset = TextFieldWithPopupHandlerUI.isSearchField(c) ? 6 : 4;
        if (TextFieldWithPopupHandlerUI.isSearchFieldWithHistoryPopup(c)) {
            return JBUI.insets((int)vOffset, (int)26, (int)vOffset, (int)23).asUIResource();
        }
        if (TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return JBUI.insets((int)vOffset, (int)23, (int)vOffset, (int)23).asUIResource();
        }
        if (c instanceof JTextField && c.getParent() instanceof ColorPanel) {
            return JBUI.insets((int)3, (int)3, (int)2, (int)2).asUIResource();
        }
        return JBUI.insets((int)vOffset, (int)7, (int)vOffset, (int)7).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(x, y);
            Object eop = ((JComponent)c).getClientProperty("JComponent.error.outline");
            if (Registry.is((String)"ide.inplace.errors.outline") && Boolean.parseBoolean(String.valueOf(eop))) {
                DarculaUIUtil.paintErrorBorder(g2, width, height, JBUI.scale((int)5), true, c.hasFocus());
            } else if (c.hasFocus()) {
                DarculaUIUtil.paintFocusRing(g2, new Rectangle(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2)));
            } else {
                boolean editable = !(c instanceof JTextComponent) || ((JTextComponent)c).isEditable();
                g2.setColor(DarculaTextBorder.getBorderColor(c.isEnabled() && editable));
                g2.drawRect(JBUI.scale((int)1), JBUI.scale((int)1), width - JBUI.scale((int)2), height - JBUI.scale((int)2));
            }
        }
        finally {
            g2.dispose();
        }
    }

    private static Color getBorderColor(boolean enabled) {
        if (UIUtil.isUnderDarcula()) {
            return enabled ? Gray._100 : Gray._83;
        }
        return Gray._150;
    }
}

