/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.intellij.MacIntelliJComboBoxUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MacComboBoxBorder
extends MacIntelliJTextBorder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(x, y);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            Shape clip = g2.getClip();
            Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
            area.subtract(this.getButtonBounds(c));
            area.intersect(new Area(clip));
            g2.setClip(area);
            int arc = this.isRound(c) ? JBUI.scale((int)6) : 0;
            Insets i2 = ((JComponent)c).getInsets();
            if (c instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)c;
                ComboBoxEditor cbe = comboBox.getEditor();
                Color background = comboBox.isEditable() ? cbe.getEditorComponent().getBackground() : UIManager.getColor(comboBox.isEnabled() ? "ComboBox.background" : "ComboBox.disabledBackground");
                g2.setColor(background);
                if (comboBox.isEditable()) {
                    Rectangle2D.Double shape = new Rectangle2D.Double(i2.left, i2.top, width - (i2.left + i2.right), height - (i2.top + i2.bottom));
                    g2.fill(shape);
                } else {
                    Path2D.Double path = new Path2D.Double(0);
                    ((Path2D)path).moveTo(i2.left + MacIntelliJComboBoxUI.VALUE_OFFSET, i2.top);
                    ((Path2D)path).lineTo(i2.left + MacIntelliJComboBoxUI.VALUE_OFFSET, c.getHeight() - i2.bottom);
                    ((Path2D)path).lineTo(i2.left + arc, c.getHeight() - i2.bottom);
                    ((Path2D)path).quadTo(i2.left, c.getHeight() - i2.bottom, i2.left, c.getHeight() - arc - i2.bottom);
                    ((Path2D)path).lineTo(i2.left, arc + i2.top);
                    ((Path2D)path).quadTo(i2.left, i2.top, arc + i2.left, i2.top);
                    path.closePath();
                    g2.fill(path);
                }
            }
            Path2D.Double border = new Path2D.Double(0);
            double lw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
            border.append(new RoundRectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), c.getWidth() - JBUI.scale((int)6), c.getHeight() - JBUI.scale((int)6), arc, arc), false);
            double innerArc = arc > 0 ? (double)arc - lw : 0.0;
            border.append(new RoundRectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)(c.getWidth() - JBUI.scale((int)6)) - lw * 2.0, (double)(c.getHeight() - JBUI.scale((int)6)) - lw * 2.0, innerArc, innerArc), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(border);
            g2.setClip(clip);
            this.paint(c, g2, width, height, arc);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new JBInsets(3, 3, 3, 3);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    boolean isFocused(Component c) {
        if (c instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)c;
            if (!comboBox.isEnabled()) {
                return false;
            }
            if (comboBox.isEditable()) {
                ComboBoxEditor ed = comboBox.getEditor();
                Component editorComponent = ed.getEditorComponent();
                Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                return focused != null && editorComponent != null && SwingUtilities.isDescendingFrom(focused, editorComponent);
            }
            return comboBox.hasFocus();
        }
        return false;
    }

    Area getButtonBounds(Component c) {
        Rectangle bounds = null;
        if (c instanceof JComboBox && ((JComboBox)c).getUI() instanceof MacIntelliJComboBoxUI) {
            MacIntelliJComboBoxUI ui = (MacIntelliJComboBoxUI)((JComboBox)c).getUI();
            bounds = ui.getArrowButtonBounds();
        }
        return bounds != null ? new Area(bounds) : new Area();
    }

    boolean isRound(Component c) {
        return c instanceof JComboBox && !((JComboBox)c).isEditable();
    }

    @Override
    void clipForBorder(Component c, Graphics2D g2, int width, int height) {
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        double lw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
        RectangularShape innerShape = this.isRound(c) ? new RoundRectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)(width - JBUI.scale((int)6)) - lw * 2.0, (double)(height - JBUI.scale((int)6)) - lw * 2.0, (double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw) : new Rectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)(width - JBUI.scale((int)6)) - lw * 2.0, (double)(height - JBUI.scale((int)6)) - lw * 2.0);
        area.subtract(new Area(innerShape));
        area.add(this.getButtonBounds(c));
        Area clip = new Area(g2.getClip());
        area.intersect(clip);
        g2.setClip(area);
    }

    @Override
    boolean isSymmetric() {
        return false;
    }
}

