/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class MacIntelliJTextBorder
implements Border,
UIResource,
ErrorBorderCapable {
    @Override
    public Insets getBorderInsets(Component c) {
        return JBUI.insets((int)3, (int)6).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (TextFieldWithPopupHandlerUI.isSearchField(c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.translate(x, y);
            Path2D.Double border = new Path2D.Double(0);
            double lw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
            border.append(new Rectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), c.getWidth() - JBUI.scale((int)6), c.getHeight() - JBUI.scale((int)6)), false);
            border.append(new Rectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)(c.getWidth() - JBUI.scale((int)6)) - lw * 2.0, (double)(c.getHeight() - JBUI.scale((int)6)) - lw * 2.0), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(border);
            if (c.getParent() instanceof JComboBox) {
                return;
            }
            this.paint(c, g2, width, height, 0);
        }
        finally {
            g2.dispose();
        }
    }

    public void paint(Component c, Graphics2D g2, int width, int height, int arc) {
        this.clipForBorder(c, g2, width, height);
        Object eop = ((JComponent)c).getClientProperty("JComponent.error.outline");
        if (Registry.is((String)"ide.inplace.errors.outline") && Boolean.parseBoolean(String.valueOf(eop))) {
            DarculaUIUtil.paintErrorBorder(g2, width, height, arc, this.isSymmetric(), this.isFocused(c));
        } else if (this.isFocused(c)) {
            DarculaUIUtil.paintFocusBorder(g2, width, height, arc, this.isSymmetric());
        }
    }

    boolean isFocused(Component c) {
        return c instanceof JScrollPane ? ((JScrollPane)c).getViewport().getView().hasFocus() : c.hasFocus();
    }

    void clipForBorder(Component c, Graphics2D g2, int width, int height) {
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        double lw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
        area.subtract(new Area(new Rectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)(width - JBUI.scale((int)6)) - lw * 2.0, (double)(height - JBUI.scale((int)6)) - lw * 2.0)));
        area.intersect(new Area(g2.getClip()));
        g2.setClip(area);
    }

    boolean isSymmetric() {
        return true;
    }
}

