/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class MacIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public MacIntelliJTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJTextFieldUI((JTextField)c);
    }

    @Override
    public void showSearchPopup() {
        Object value2 = this.myTextField.getClientProperty("JTextField.Search.FindPopup");
        JTextComponent editor = this.getComponent();
        if (editor != null && value2 instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value2;
            popup.show(editor, this.getSearchIconCoord().x, editor.getHeight());
        }
    }

    @Override
    public String getToolTipText(JTextComponent t, Point pt) {
        AbstractAction action;
        if (this.getActionUnder(pt) == TextFieldWithPopupHandlerUI.SearchAction.NEWLINE && (action = MacIntelliJTextFieldUI.getNewLineAction(t)) != null) {
            return (String)action.getValue("ShortDescription");
        }
        return super.getToolTipText(t, pt);
    }

    @Override
    public TextFieldWithPopupHandlerUI.SearchAction getActionUnder(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ide/ui/laf/intellij/MacIntelliJTextFieldUI", "getActionUnder"));
        }
        int off = JBUI.scale((int)8);
        Point point = new Point(p.x - off, p.y - off);
        if (point.distance(this.getSearchIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.POPUP;
        }
        if (this.hasText() && point.distance(this.getClearIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.CLEAR;
        }
        if (MacIntelliJTextFieldUI.getNewLineAction(this.myTextField) != null && point.distance(this.getAddNewLineIconCoord()) <= (double)off) {
            return TextFieldWithPopupHandlerUI.SearchAction.NEWLINE;
        }
        return null;
    }

    protected Rectangle getDrawingRect() {
        return new Rectangle(0, (this.myTextField.getHeight() - 28) / 2, this.myTextField.getWidth(), this.myTextField.getHeight());
    }

    private static Icon getSearchIcon(Component c) {
        return MacIntelliJIconCache.getIcon(MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c) ? "searchFieldWithHistory" : "search");
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect();
        Icon icon = MacIntelliJTextFieldUI.getSearchIcon(this.myTextField);
        return new Point(r.x + (this.hasText() || this.myTextField.hasFocus() || MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(this.myTextField) ? JBUI.scale((int)8) : (r.width - icon.getIconWidth()) / 2), r.y + (r.height - icon.getIconHeight()) / 2);
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect();
        Icon icon = MacIntelliJIconCache.getIcon("searchFieldClear");
        return new Point(r.x + r.width - icon.getIconWidth() - JBUI.scale((int)6), r.y + (r.height - icon.getIconHeight()) / 2);
    }

    protected Point getAddNewLineIconCoord() {
        Point point = this.getClearIconCoord();
        if (!StringUtil.isEmpty((String)this.myTextField.getText())) {
            point.x -= JBUI.scale((int)16) + JBUI.scale((int)8);
        }
        return point;
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        Rectangle r = this.getDrawingRect();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (MacIntelliJTextFieldUI.isSearchField(c)) {
            this.paintSearchField(g, c, r);
        } else if (c.getBorder() instanceof MacIntelliJTextBorder) {
            g.setColor(c.getBackground());
            g.fillRect(JBUI.scale((int)3), JBUI.scale((int)3), c.getWidth() - JBUI.scale((int)6), c.getHeight() - JBUI.scale((int)6));
        } else {
            super.paintBackground(g);
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        Dimension dimension = new Dimension(size.width + this.getIconsWidth(c), Math.max(28, size.height));
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/intellij/MacIntelliJTextFieldUI", "getPreferredSize"));
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension minimumSize = super.getMinimumSize(c);
        return new Dimension(minimumSize.width + this.getIconsWidth(c), minimumSize.height);
    }

    private int getIconsWidth(JComponent c) {
        int width = 0;
        if (MacIntelliJTextFieldUI.isSearchField(c)) {
            Icon label = MacIntelliJTextFieldUI.getSearchIcon(c);
            width += label.getIconWidth();
            if (this.hasText()) {
                Icon clearIcon = MacIntelliJIconCache.getIcon("searchFieldClear");
                width += clearIcon.getIconWidth() + 3;
            }
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintSearchField(Graphics2D g, JTextComponent c, Rectangle r) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Icon newLineIcon;
            AbstractAction newLineAction;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            int arc = JBUI.scale((int)6);
            double lw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
            RoundRectangle2D.Double outerShape = new RoundRectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), r.width - JBUI.scale((int)6), r.height - JBUI.scale((int)6), arc, arc);
            g2.setColor(c.getBackground());
            g2.fill(outerShape);
            Path2D.Double path = new Path2D.Double(0);
            path.append(outerShape, false);
            path.append(new RoundRectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)(r.width - JBUI.scale((int)6)) - lw * 2.0, (double)(r.height - JBUI.scale((int)6)) - lw * 2.0, (double)arc - lw, (double)arc - lw), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(path);
            if (c.hasFocus() && c.getClientProperty("JTextField.Search.noBorderRing") != Boolean.TRUE) {
                DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
            }
            g2.translate(-r.x, -r.y);
            boolean withHistoryPopup = MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c);
            Icon label = MacIntelliJTextFieldUI.getSearchIcon(c);
            boolean isEmpty = !this.hasText();
            Point point = this.getSearchIconCoord();
            if (isEmpty && !c.hasFocus() && !withHistoryPopup) {
                label.paintIcon(c, g2, point.x, point.y);
            } else {
                Graphics ig = g2.create(0, 0, c.getWidth(), c.getHeight());
                Area area = new Area(new Rectangle2D.Double(point.x, point.y, isEmpty ? (double)label.getIconWidth() : 16.0, label.getIconHeight()));
                area.intersect(new Area(ig.getClip()));
                ig.setClip(area);
                label.paintIcon(c, ig, point.x, point.y);
                ig.dispose();
            }
            if (!isEmpty) {
                Point ic = this.getClearIconCoord();
                MacIntelliJIconCache.getIcon("searchFieldClear").paintIcon(c, g2, ic.x, ic.y);
            }
            if ((newLineAction = MacIntelliJTextFieldUI.getNewLineAction(c)) != null && (newLineIcon = (Icon)newLineAction.getValue("SmallIcon")) != null) {
                newLineIcon.paintIcon(c, g2, this.getAddNewLineIconCoord().x, r.y);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect != null) {
            if (MacIntelliJTextFieldUI.isSearchField(this.myTextField)) {
                int extraOffset = MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(this.myTextField) ? 3 : 0;
                rect.width -= 36 + extraOffset;
                if (MacIntelliJTextFieldUI.getNewLineAction(this.myTextField) != null) {
                    rect.width -= 24;
                }
                rect.x += 19 + extraOffset;
                if (rect.height % 2 == 1) {
                    ++rect.y;
                }
            } else {
                rect.x += 2;
                rect.width -= 4;
            }
        }
        return rect;
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintAquaSearchFocusRing(Graphics2D g, Rectangle r, Component c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            int arc = JBUI.scale((int)6);
            double lw = UIUtil.isRetina((Graphics2D)g2) ? 0.5 : 1.0;
            RoundRectangle2D.Double outerShape = new RoundRectangle2D.Double(JBUI.scale((int)3), JBUI.scale((int)3), r.width - JBUI.scale((int)6), r.height - JBUI.scale((int)6), arc, arc);
            g2.setColor(c.getBackground());
            g2.fill(outerShape);
            Path2D.Double path = new Path2D.Double(0);
            path.append(outerShape, false);
            path.append(new RoundRectangle2D.Double((double)JBUI.scale((int)3) + lw, (double)JBUI.scale((int)3) + lw, (double)(r.width - JBUI.scale((int)6)) - lw * 2.0, (double)(r.height - JBUI.scale((int)6)) - lw * 2.0, (double)arc - lw, (double)arc - lw), false);
            g2.setColor((Color)Gray.xBC);
            g2.fill(path);
            if (c.hasFocus()) {
                DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

