/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class WinIntelliJButtonBorder
implements Border,
UIResource {
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        WinIntelliJButtonBorder.paint(c, g, x, y, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paint(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof AbstractButton) || DarculaButtonUI.isHelpButton((JComponent)c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        AbstractButton b = (AbstractButton)c;
        ButtonModel bm = b.getModel();
        Rectangle r = new Rectangle(x, y, width, height);
        try {
            if (DarculaButtonUI.isSquare(c)) {
                JBInsets.removeFrom((Rectangle)r, (Insets)b.getInsets());
            }
            g2.translate(r.x, r.y);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Color color = UIManager.getColor("Button.intellij.native.borderColor");
            int bw = JBUI.scale((int)1);
            if (!c.isEnabled()) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
            } else if (bm.isPressed()) {
                color = UIManager.getColor("Button.intellij.native.pressedBorderColor");
            } else if (b.hasFocus() || bm.isRollover()) {
                color = UIManager.getColor("Button.intellij.native.focusedBorderColor");
            } else if (DarculaButtonUI.isDefaultButton(b)) {
                bw = JBUI.scale((int)2);
                color = UIManager.getColor("Button.intellij.native.focusedBorderColor");
            }
            Path2D.Double border = new Path2D.Double(0);
            border.append(new Rectangle2D.Double(0.0, 0.0, r.width, r.height), false);
            border.append(new Rectangle2D.Double(bw, bw, r.width - 2 * bw, r.height - 2 * bw), false);
            g2.setColor(color);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c.getParent() instanceof ActionToolbar) {
            return JBUI.insets((int)4, (int)16).asUIResource();
        }
        if (DarculaButtonUI.isSquare(c)) {
            return JBUI.insets((int)1).asUIResource();
        }
        if (DarculaButtonUI.isHelpButton((JComponent)c)) {
            return JBUI.insets((int)0, (int)0, (int)0, (int)10).asUIResource();
        }
        return JBUI.insets((int)3, (int)17).asUIResource();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

