/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.WinIntelliJButtonBorder;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.SwingUtilities2;

public class WinIntelliJButtonUI
extends DarculaButtonUI {
    static final float DISABLED_ALPHA_LEVEL = 0.47f;
    private PropertyChangeListener helpButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof AbstractButton && DarculaButtonUI.isHelpButton((JComponent)source)) {
                ((AbstractButton)source).setOpaque(false);
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        ((AbstractButton)c).setRolloverEnabled(true);
        return new WinIntelliJButtonUI();
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("JButton.buttonType", this.helpButtonListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        b.removePropertyChangeListener("JButton.buttonType", this.helpButtonListener);
        super.uninstallListeners(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        if (WinIntelliJButtonUI.isHelpButton(c)) {
            Icon help = MacIntelliJIconCache.getIcon("winHelp");
            Insets i2 = c.getInsets();
            help.paintIcon(c, g, i2.left, i2.top + (c.getHeight() - help.getIconHeight()) / 2);
        } else if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel bm = b.getModel();
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Rectangle r = new Rectangle(c.getSize());
                Container parent = c.getParent();
                if (c.isOpaque() && parent != null) {
                    g2.setColor(parent.getBackground());
                    g2.fill(r);
                }
                if (WinIntelliJButtonUI.isSquare(c)) {
                    JBInsets.removeFrom((Rectangle)r, (Insets)c.getInsets());
                }
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                Color color = bm.isPressed() ? UIManager.getColor("Button.intellij.native.pressedBackgroundColor") : (c.hasFocus() || bm.isRollover() ? UIManager.getColor("Button.intellij.native.focusedBackgroundColor") : c.getBackground());
                g2.setColor(color);
                g2.fill(r);
                this.paintContents(g2, b);
            }
            finally {
                g2.dispose();
            }
        }
        if (!(c.getBorder() instanceof WinIntelliJButtonBorder)) {
            WinIntelliJButtonBorder.paint(c, g, 0, 0, c.getWidth(), c.getHeight());
        }
    }

    @Override
    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        if (!WinIntelliJButtonUI.isComboButton(b)) {
            JBInsets.removeFrom((Rectangle)rect, (Insets)b.getInsets());
        }
        if (WinIntelliJButtonUI.isComboButton(b)) {
            rect.x += JBUI.scale((int)5);
        } else if (b instanceof JBOptionButton) {
            rect.x -= JBUI.scale((int)4);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (WinIntelliJButtonUI.isHelpButton(c)) {
            Icon icon = MacIntelliJIconCache.getIcon("winHelp");
            Insets i2 = c.getInsets();
            return new Dimension(icon.getIconWidth() + i2.left + i2.right, JBUI.scale((int)22));
        }
        if (WinIntelliJButtonUI.isSquare(c)) {
            return new JBDimension(22, 22);
        }
        return super.getPreferredSize(c);
    }

    @Override
    protected void setupDefaultButton(JButton button) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDisabledText(Graphics g, String text2, JComponent c, Rectangle textRect, FontMetrics metrics) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor(UIManager.getColor("Button.disabledText"));
            g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
            SwingUtilities2.drawStringUnderlineCharAt(c, g2, text2, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        }
        finally {
            g2.dispose();
        }
    }
}

