/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseElementsDialog<T>
extends DialogWrapper {
    protected ElementsChooser<T> myChooser;
    private String myDescription;

    public ChooseElementsDialog(Project project2, List<? extends T> items, String title, String description) {
        this(project2, items, title, description, false);
    }

    public ChooseElementsDialog(Project project2, List<? extends T> items, String title, String description, boolean sort) {
        super(project2, true);
        this.myDescription = description;
        this.initializeDialog(items, title, sort);
    }

    public ChooseElementsDialog(Component parent, List<T> items, String title) {
        this(parent, items, title, null, false);
    }

    public ChooseElementsDialog(Component parent, List<T> items, String title, @Nullable String description, boolean sort) {
        super(parent, true);
        this.myDescription = description;
        this.initializeDialog(items, title, sort);
    }

    private void initializeDialog(List<? extends T> items, String title, boolean sort) {
        this.setTitle(title);
        this.myChooser = new ElementsChooser<T>(false){

            @Override
            protected String getItemText(@NotNull T item) {
                if (item == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/util/ChooseElementsDialog$1", "getItemText"));
                }
                return ChooseElementsDialog.this.getItemText(item);
            }
        };
        this.myChooser.setColorUnmarkedElements(false);
        ArrayList<T> elements = new ArrayList<T>(items);
        if (sort) {
            Collections.sort(elements, (o1, o2) -> this.getItemText(o1).compareToIgnoreCase(this.getItemText(o2)));
        }
        this.setElements(elements, elements.size() > 0 ? elements.subList(0, 1) : Collections.emptyList());
        this.myChooser.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseElementsDialog.this.doOKAction();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                ChooseElementsDialog.this.doOKAction();
                return true;
            }
        }.installOn((Component)this.myChooser.getComponent());
        this.init();
    }

    @NotNull
    public List<T> showAndGetResult() {
        this.show();
        List<T> list2 = this.getChosenElements();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ChooseElementsDialog", "showAndGetResult"));
        }
        return list2;
    }

    protected abstract String getItemText(T var1);

    @Nullable
    protected abstract Icon getItemIcon(T var1);

    @NotNull
    public List<T> getChosenElements() {
        List list2 = this.isOK() ? this.myChooser.getSelectedElements() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ChooseElementsDialog", "getChosenElements"));
        }
        return list2;
    }

    public void selectElements(@NotNull List<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/util/ChooseElementsDialog", "selectElements"));
        }
        this.myChooser.selectElements(elements);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChooser.getComponent();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myChooser.getComponent()), "Center");
        if (this.myDescription != null) {
            panel2.add((Component)new JLabel(this.myDescription), "North");
        }
        return panel2;
    }

    private void setElements(Collection<? extends T> elements, Collection<? extends T> elementsToSelect) {
        this.myChooser.clear();
        for (T item : elements) {
            this.myChooser.addElement(item, false, this.createElementProperties(item));
        }
        this.myChooser.selectElements(elementsToSelect);
    }

    private MultiStateElementsChooser.ElementProperties createElementProperties(final T item) {
        return new MultiStateElementsChooser.ElementProperties(){

            @Override
            public Icon getIcon() {
                return ChooseElementsDialog.this.getItemIcon(item);
            }

            @Override
            public Color getColor() {
                return null;
            }
        };
    }
}

