/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipUIUtil {
    private static final Logger LOG = Logger.getInstance(TipUIUtil.class);
    private static final String SHORTCUT_ENTITY = "&shortcut:";

    private TipUIUtil() {
    }

    @NotNull
    public static String getPoweredByText(@NotNull TipAndTrickBean tip) {
        if (tip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tip", "com/intellij/ide/util/TipUIUtil", "getPoweredByText"));
        }
        PluginDescriptor descriptor = tip.getPluginDescriptor();
        String string = descriptor instanceof IdeaPluginDescriptor && !"com.intellij".equals(descriptor.getPluginId().getIdString()) ? ((IdeaPluginDescriptor)descriptor).getName() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TipUIUtil", "getPoweredByText"));
        }
        return string;
    }

    public static void openTipInBrowser(String tipFileName, JEditorPane browser, Class providerClass) {
        TipAndTrickBean tip = TipAndTrickBean.findByFileName(tipFileName);
        if (tip == null && StringUtil.isNotEmpty((String)tipFileName)) {
            tip = new TipAndTrickBean();
            tip.fileName = tipFileName;
        }
        TipUIUtil.openTipInBrowser(tip, browser);
    }

    public static void openTipInBrowser(@Nullable TipAndTrickBean tip, JEditorPane browser) {
        if (tip == null) {
            return;
        }
        try {
            PluginDescriptor pluginDescriptor = tip.getPluginDescriptor();
            ClassLoader tipLoader = pluginDescriptor == null ? TipUIUtil.class.getClassLoader() : (ClassLoader)ObjectUtils.notNull((Object)pluginDescriptor.getPluginClassLoader(), (Object)TipUIUtil.class.getClassLoader());
            URL url = ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)tip.fileName);
            if (url == null) {
                TipUIUtil.setCantReadText(browser, tip);
                return;
            }
            StringBuffer text2 = new StringBuffer(ResourceUtil.loadText((URL)url));
            TipUIUtil.updateShortcuts(text2);
            TipUIUtil.updateImages(text2, tipLoader, browser);
            String replaced = text2.toString().replace("&productName;", ApplicationNamesInfo.getInstance().getFullProductName());
            String major = ApplicationInfo.getInstance().getMajorVersion();
            replaced = replaced.replace("&majorVersion;", major);
            String minor = ApplicationInfo.getInstance().getMinorVersion();
            replaced = replaced.replace("&minorVersion;", minor);
            replaced = replaced.replace("&majorMinorVersion;", major + ("0".equals(minor) ? "" : "." + minor));
            replaced = replaced.replace("&settingsPath;", CommonBundle.settingsActionPath());
            replaced = replaced.replaceFirst("<link rel=\"stylesheet\".*tips\\.css\">", "");
            if (browser.getUI() == null) {
                browser.updateUI();
                boolean succeed = browser.getUI() != null;
                String message2 = "reinit JEditorPane.ui: " + (succeed ? "OK" : "FAIL") + ", laf=" + LafManager.getInstance().getCurrentLookAndFeel();
                if (succeed) {
                    LOG.warn(message2);
                } else {
                    LOG.error(message2);
                }
            }
            browser.read(new StringReader(replaced), (Object)url);
        }
        catch (IOException e) {
            TipUIUtil.setCantReadText(browser, tip);
        }
    }

    private static void setCantReadText(JEditorPane browser, TipAndTrickBean bean) {
        try {
            String plugin = TipUIUtil.getPoweredByText(bean);
            String product = ApplicationNamesInfo.getInstance().getFullProductName();
            if (!plugin.isEmpty()) {
                product = product + " and " + plugin + " plugin";
            }
            String message2 = IdeBundle.message((String)"error.unable.to.read.tip.of.the.day", (Object[])new Object[]{bean.fileName, product});
            browser.read(new StringReader(message2), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void updateImages(StringBuffer text2, ClassLoader tipLoader, JEditorPane browser) {
        boolean dark = UIUtil.isUnderDarcula();
        Window af = IdeFrameImpl.getActiveFrame();
        Container comp = af != null ? af : browser;
        int index = text2.indexOf("<img", 0);
        while (index != -1) {
            String path;
            int srcIndex;
            int end = text2.indexOf(">", index + 1);
            if (end == -1) {
                return;
            }
            String img = text2.substring(index, end + 1).replace('\r', ' ').replace('\n', ' ');
            int endIndex = img.indexOf(".png", srcIndex = img.indexOf("src="));
            if (endIndex != -1 && !(path = img.substring(srcIndex + 5, endIndex)).endsWith("_dark") && !path.endsWith("@2x")) {
                boolean hidpi = JBUI.isPixHiDPI((Component)comp);
                URL url = ResourceUtil.getResource((ClassLoader)tipLoader, (String)"/tips/", (String)(path = path + (hidpi ? "@2x" : "") + (dark ? "_dark" : "") + ".png"));
                if (url != null) {
                    String newImgTag = "<img src=\"" + path + "\" ";
                    try {
                        BufferedImage image = ImageIO.read(url.openStream());
                        int w = image.getWidth();
                        int h = image.getHeight();
                        if (UIUtil.isJreHiDPI((Component)comp)) {
                            float sysScale = JBUI.sysScale((Component)comp);
                            w = (int)((float)w / sysScale);
                            h = (int)((float)h / sysScale);
                        } else {
                            float imgScale = hidpi ? 2.0f : 1.0f;
                            w = (int)((float)w / imgScale);
                            h = (int)((float)h / imgScale);
                        }
                        w = (int)JBUI.scale((float)w);
                        h = (int)JBUI.scale((float)h);
                        newImgTag = newImgTag + "width=\"" + w + "\" height=\"" + h + "\"";
                    }
                    catch (Exception ignore) {
                        newImgTag = newImgTag + "width=\"400\" height=\"200\"";
                    }
                    newImgTag = newImgTag + "/>";
                    text2.replace(index, end + 1, newImgTag);
                }
            }
            index = text2.indexOf("<img", index + 1);
        }
    }

    private static void updateShortcuts(StringBuffer text2) {
        int lastIndex = 0;
        while ((lastIndex = text2.indexOf(SHORTCUT_ENTITY, lastIndex)) >= 0) {
            Keymap defKeymap;
            int actionIdStart = lastIndex + SHORTCUT_ENTITY.length();
            int actionIdEnd = text2.indexOf(";", actionIdStart);
            if (actionIdEnd < 0) {
                return;
            }
            String actionId = text2.substring(actionIdStart, actionIdEnd);
            String shortcutText = TipUIUtil.getShortcutText(actionId, KeymapManager.getInstance().getActiveKeymap());
            if (shortcutText == null && (defKeymap = KeymapManager.getInstance().getKeymap(DefaultKeymap.getInstance().getDefaultKeymapName())) != null && (shortcutText = TipUIUtil.getShortcutText(actionId, defKeymap)) != null) {
                shortcutText = shortcutText + " in default keymap";
            }
            if (shortcutText == null) {
                shortcutText = "<no shortcut for action " + actionId + ">";
            }
            text2.replace(lastIndex, actionIdEnd + 1, shortcutText);
            lastIndex += shortcutText.length();
        }
        return;
    }

    @Nullable
    private static String getShortcutText(String actionId, Keymap keymap) {
        for (Shortcut shortcut : keymap.getShortcuts(actionId)) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        return null;
    }

    @NotNull
    public static JEditorPane createTipBrowser() {
        JEditorPane browser = new JEditorPane();
        browser.setEditable(false);
        browser.setBackground(UIUtil.getTextFieldBackground());
        browser.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserUtil.browse((URL)e.getURL());
                }
            }
        });
        URL resource = ResourceUtil.getResource(TipUIUtil.class, (String)"/tips/css/", (String)(UIUtil.isUnderDarcula() ? "tips_darcula.css" : "tips.css"));
        HTMLEditorKit kit = UIUtil.getHTMLEditorKit((boolean)false);
        kit.getStyleSheet().addStyleSheet(UIUtil.loadStyleSheet((URL)resource));
        browser.setEditorKit(kit);
        JEditorPane jEditorPane = browser;
        if (jEditorPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/TipUIUtil", "createTipBrowser"));
        }
        return jEditorPane;
    }
}

