/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectLayoutPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ModulesLayoutPanel
extends ProjectLayoutPanel<ModuleDescriptor> {
    private final LibraryFilter myLibrariesFilter;

    public ModulesLayoutPanel(ModuleInsight insight, LibraryFilter libFilter) {
        super(insight);
        this.myLibrariesFilter = libFilter;
    }

    @Override
    protected String getElementName(ModuleDescriptor entry) {
        return entry.getName();
    }

    @Override
    protected void setElementName(ModuleDescriptor entry, String name2) {
        entry.setName(name2);
    }

    @Override
    protected List<ModuleDescriptor> getEntries() {
        List<ModuleDescriptor> modules = this.getInsight().getSuggestedModules();
        return modules != null ? modules : Collections.emptyList();
    }

    @Override
    protected Collection getDependencies(ModuleDescriptor entry) {
        ArrayList<Object> deps = new ArrayList<Object>();
        deps.addAll(entry.getDependencies());
        Collection<LibraryDescriptor> libDependencies = this.getInsight().getLibraryDependencies(entry);
        for (LibraryDescriptor libDependency : libDependencies) {
            if (!this.myLibrariesFilter.isLibraryChosen(libDependency)) continue;
            deps.add(libDependency);
        }
        return deps;
    }

    @Override
    @Nullable
    protected ModuleDescriptor merge(List<ModuleDescriptor> entries) {
        ModuleInsight insight = this.getInsight();
        ModuleDescriptor mainDescr = null;
        for (ModuleDescriptor entry : entries) {
            if (mainDescr == null) {
                mainDescr = entry;
                continue;
            }
            insight.merge(mainDescr, entry);
        }
        return mainDescr;
    }

    @Override
    protected ModuleDescriptor split(ModuleDescriptor entry, String newEntryName, Collection<File> extractedData) {
        return this.getInsight().splitModule(entry, newEntryName, extractedData);
    }

    @Override
    protected Collection<File> getContent(ModuleDescriptor entry) {
        return entry.getContentRoots();
    }

    @Override
    protected String getEntriesChooserTitle() {
        return "Modules";
    }

    @Override
    protected String getDependenciesTitle() {
        return "Module dependencies";
    }

    @Override
    protected String getElementTypeName() {
        return "module";
    }

    @Override
    protected String getSplitDialogChooseFilesPrompt() {
        return "&Select content roots to extract to the new module:";
    }

    @Override
    protected String getNameAlreadyUsedMessage(String name2) {
        return "Module with name " + name2 + " already exists";
    }

    @Override
    protected String getStepDescriptionText() {
        return "Please review suggested module structure for the project. At this stage you can set module names,\nexclude particular modules from the project, merge or split individual modules.\nAll dependencies between the modules as well as dependencies on the libraries will be automatically updated.";
    }

    public static interface LibraryFilter {
        public boolean isLibraryChosen(LibraryDescriptor var1);
    }
}

