/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.SdkSettingsStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaSettingsStep
extends SdkSettingsStep {
    @NotNull
    @NonNls
    private static final String MODULE_SOURCE_ROOT_KEY = "java.module.default.source.root";
    @NotNull
    @NonNls
    private static final String DEFAULT_MODULE_SOURCE_ROOT_PATH = "src";
    private final ModuleBuilder myModuleBuilder;
    private JBCheckBox myCreateSourceRoot;
    private TextFieldWithBrowseButton mySourcePath;
    private JPanel myPanel;

    public JavaSettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> sdkFilter) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/ide/util/projectWizard/JavaSettingsStep", "<init>"));
        }
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/ide/util/projectWizard/JavaSettingsStep", "<init>"));
        }
        if (sdkFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkFilter", "com/intellij/ide/util/projectWizard/JavaSettingsStep", "<init>"));
        }
        super(settingsStep, moduleBuilder, sdkFilter);
        this.$$$setupUI$$$();
        this.mySourcePath.setText(PropertiesComponent.getInstance().getValue(MODULE_SOURCE_ROOT_KEY, DEFAULT_MODULE_SOURCE_ROOT_PATH));
        this.myModuleBuilder = moduleBuilder;
        if (moduleBuilder instanceof JavaModuleBuilder) {
            this.addSourcePath(settingsStep);
        }
    }

    private void addSourcePath(SettingsStep settingsStep) {
        Project project2 = settingsStep.getContext().getProject();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(IdeBundle.message((String)"prompt.select.source.directory", (Object[])new Object[0]));
        this.mySourcePath.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, project2){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/ide/util/projectWizard/JavaSettingsStep$1", "chosenFileToResultingText"));
                }
                String contentEntryPath = JavaSettingsStep.this.myModuleBuilder.getContentEntryPath();
                String path = chosenFile.getPath();
                String string = contentEntryPath == null ? path : path.substring(StringUtil.commonPrefixLength((CharSequence)contentEntryPath, (CharSequence)path));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/JavaSettingsStep$1", "chosenFileToResultingText"));
                }
                return string;
            }
        });
        this.myCreateSourceRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaSettingsStep.this.mySourcePath.setEnabled(JavaSettingsStep.this.myCreateSourceRoot.isSelected());
            }
        });
        settingsStep.addExpertPanel((JComponent)this.myPanel);
    }

    @Override
    public void updateDataModel() {
        super.updateDataModel();
        if (this.myModuleBuilder instanceof JavaModuleBuilder) {
            if (this.myCreateSourceRoot.isSelected()) {
                String contentEntryPath = this.myModuleBuilder.getContentEntryPath();
                if (contentEntryPath != null) {
                    String dirName = this.mySourcePath.getText().trim().replace(File.separatorChar, '/');
                    PropertiesComponent.getInstance().setValue(MODULE_SOURCE_ROOT_KEY, dirName);
                    String text2 = dirName.length() > 0 ? contentEntryPath + "/" + dirName : contentEntryPath;
                    ((JavaModuleBuilder)this.myModuleBuilder).setSourcePaths(Collections.singletonList(Pair.create((Object)text2, (Object)"")));
                }
            } else {
                ((JavaModuleBuilder)this.myModuleBuilder).setSourcePaths(Collections.emptyList());
            }
        }
    }

    public void setSourcePath(String path) {
        this.mySourcePath.setText(path);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourcePath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCreateSourceRoot = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Create source root:");
        jBCheckBox.setMnemonic('C');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jBCheckBox.setSelected(true);
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

