/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdom.Document;
import org.jdom.output.DOMOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private boolean myInitialized = false;

    private LoggerFactory() {
    }

    @NotNull
    public synchronized com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/idea/LoggerFactory", "getLoggerInstance"));
        }
        try {
            if (!this.myInitialized) {
                this.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IdeaLogger ideaLogger = new IdeaLogger(Logger.getLogger((String)name2));
        if (ideaLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/LoggerFactory", "getLoggerInstance"));
        }
        return ideaLogger;
    }

    private void init() {
        try {
            System.setProperty("log4j.defaultInitOverride", "true");
            File logXmlFile = PathManager.findBinFileWithException((String)"log.xml");
            String text2 = FileUtil.loadFile((File)logXmlFile);
            text2 = StringUtil.replace((String)text2, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text2 = StringUtil.replace((String)text2, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text2 = StringUtil.replace((String)text2, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)PathManager.getLogPath(), (String)"\\", (String)"\\\\"));
            File file2 = new File(PathManager.getLogPath());
            if (!file2.mkdirs() && !file2.exists()) {
                System.err.println("Cannot create log directory: " + file2);
            }
            Document document = JDOMUtil.loadDocument((CharSequence)text2);
            Element element = new DOMOutputter().output(document).getDocumentElement();
            new DOMConfigurator().doConfigure(element, LogManager.getLoggerRepository());
            this.myInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

