/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PropertyName;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageDuplicateResultsDialog
extends DialogWrapper {
    private final Project myProject;
    private final List<VirtualFile> myImages;
    private final Map<String, Set<VirtualFile>> myDuplicates;
    private final Tree myTree;
    private final ResourceModules myResourceModules = new ResourceModules();

    public ImageDuplicateResultsDialog(Project project2, List<VirtualFile> images, Map<String, Set<VirtualFile>> duplicates) {
        super(project2);
        this.myProject = project2;
        this.myImages = images;
        PropertiesComponent.getInstance((Project)this.myProject).loadFields((Object)this.myResourceModules);
        this.myDuplicates = duplicates;
        this.setModal(false);
        this.myTree = new Tree((TreeNode)new MyRootNode());
        this.myTree.setRootVisible(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyCellRenderer()));
        this.init();
        TreeUtil.expandAll((JTree)this.myTree);
        this.setTitle("Image Duplicates");
        TreeUtil.selectFirstNode((JTree)this.myTree);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actions = new Action[4];
        actions[0] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        actions[0].putValue("Name", "Fix all");
        actions[0].putValue("DefaultAction", Boolean.TRUE);
        actions[0].putValue("FocusedAction", Boolean.TRUE);
        actions[1] = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        actions[1].putValue("Name", "Fix selected");
        actions[2] = this.getCancelAction();
        actions[3] = this.getHelpAction();
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/ImageDuplicateResultsDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        DataManager.registerDataProvider((JComponent)panel2, (DataProvider)new DataProvider(){

            public Object getData(@NonNls String dataId) {
                TreePath path = ImageDuplicateResultsDialog.this.myTree.getSelectionPath();
                if (path != null) {
                    Object component = path.getLastPathComponent();
                    VirtualFile file2 = null;
                    if (component instanceof MyFileNode) {
                        component = ((MyFileNode)component).getParent();
                    }
                    if (component instanceof MyDuplicatesNode) {
                        file2 = (VirtualFile)((MyDuplicatesNode)component).getUserObject().iterator().next();
                    }
                    if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                        return file2;
                    }
                    if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId) && file2 != null) {
                        return new VirtualFile[]{file2};
                    }
                }
                return null;
            }
        });
        final JBList list2 = new JBList(new ResourceModules().getModuleNames());
        final NotNullFunction modulesRenderer = dom -> new JLabel(dom instanceof Module ? ((Module)dom).getName() : dom.toString(), PlatformIcons.SOURCE_FOLDERS_ICON, 2);
        list2.installCellRenderer(modulesRenderer);
        JPanel modulesPanel = ToolbarDecorator.createDecorator((JList)list2).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object[] all = ModuleManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).getModules();
                Arrays.sort(all, (o1, o2) -> o1.getName().compareTo(o2.getName()));
                JBList modules = new JBList(all);
                modules.installCellRenderer(modulesRenderer);
                JBPopupFactory.getInstance().createListPopupBuilder((JList)modules).setTitle("Add Resource Module").setFilteringEnabled(o -> ((Module)o).getName()).setItemChoosenCallback(() -> {
                    Object value2 = modules.getSelectedValue();
                    if (value2 instanceof Module && !ImageDuplicateResultsDialog.this.myResourceModules.contains((Module)value2)) {
                        ImageDuplicateResultsDialog.this.myResourceModules.add((Module)value2);
                        ((DefaultListModel)list2.getModel()).addElement(((Module)value2).getName());
                    }
                    ((DefaultTreeModel)ImageDuplicateResultsDialog.this.myTree.getModel()).reload();
                    TreeUtil.expandAll((JTree)ImageDuplicateResultsDialog.this.myTree);
                }).createPopup().show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object[] values;
                for (Object value2 : values = list2.getSelectedValues()) {
                    ImageDuplicateResultsDialog.this.myResourceModules.remove((String)value2);
                    ((DefaultListModel)list2.getModel()).removeElement(value2);
                }
                ((DefaultTreeModel)ImageDuplicateResultsDialog.this.myTree.getModel()).reload();
                TreeUtil.expandAll((JTree)ImageDuplicateResultsDialog.this.myTree);
            }
        }).disableDownAction().disableUpAction().createPanel();
        modulesPanel.setPreferredSize(new Dimension(-1, 60));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)new JLabel("Image modules:"), "North");
        top.add((Component)modulesPanel, "Center");
        panel2.add((Component)top, "North");
        panel2.add((Component)new JBScrollPane((Component)this.myTree), "Center");
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                PsiFile psiFile;
                VirtualFile file2 = ImageDuplicateResultsDialog.this.getFileFromSelection();
                if (file2 != null && (psiFile = PsiManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).findFile(file2)) != null) {
                    final ImplementationViewComponent viewComponent = new ImplementationViewComponent(new PsiElement[]{psiFile}, 0);
                    TreeSelectionListener listener2 = new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            PsiFile newElement;
                            VirtualFile selection = ImageDuplicateResultsDialog.this.getFileFromSelection();
                            if (selection != null && (newElement = PsiManager.getInstance((Project)ImageDuplicateResultsDialog.this.myProject).findFile(selection)) != null) {
                                viewComponent.update(new PsiElement[]{newElement}, 0);
                            }
                        }
                    };
                    ImageDuplicateResultsDialog.this.myTree.addTreeSelectionListener(listener2);
                    JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)viewComponent, viewComponent.getPreferredFocusableComponent()).setProject(ImageDuplicateResultsDialog.this.myProject).setDimensionServiceKey(ImageDuplicateResultsDialog.this.myProject, ImageDuplicateResultsDialog.class.getName(), false).setResizable(true).setMovable(true).setRequestFocus(false).setCancelCallback(() -> {
                        ImageDuplicateResultsDialog.this.myTree.removeTreeSelectionListener(listener2);
                        return true;
                    }).setTitle("Image Preview").createPopup();
                    Window window = ImageDuplicateResultsDialog.this.getWindow();
                    popup.show(new RelativePoint((Component)window, new Point(window.getWidth(), 0)));
                    viewComponent.setHint(popup, "Image Preview");
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), (JComponent)panel2);
        int total = this.myDuplicates.values().stream().mapToInt(Set::size).sum() - this.myDuplicates.size();
        JLabel label = new JLabel("<html>Press <b>Enter</b> to preview image<br>Total images found: " + this.myImages.size() + ". Total duplicates found: " + total + "</html>");
        panel2.add((Component)label, "South");
        return panel2;
    }

    protected String getDimensionServiceKey() {
        return "image.duplicates.dialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    private VirtualFile getFileFromSelection() {
        TreePath path = this.myTree.getSelectionPath();
        if (path != null) {
            Object component = path.getLastPathComponent();
            VirtualFile file2 = null;
            if (component instanceof MyFileNode) {
                component = ((MyFileNode)component).getParent();
            }
            if (component instanceof MyDuplicatesNode) {
                file2 = (VirtualFile)((MyDuplicatesNode)component).getUserObject().iterator().next();
            }
            return file2;
        }
        return null;
    }

    private static String getRelativePathToProject(Project project2, VirtualFile file2) {
        String path = project2.getBasePath();
        assert (path != null);
        String result2 = FileUtil.getRelativePath((String)path, (String)file2.getPath().replace('/', File.separatorChar), (char)File.separatorChar);
        assert (result2 != null);
        return result2;
    }

    static class ResourceModules {
        @PropertyName(value="resource.modules", defaultValue="icons")
        public String modules;

        ResourceModules() {
        }

        public List<String> getModuleNames() {
            return Arrays.asList(StringUtil.splitByLines((String)(this.modules == null ? "icons" : this.modules)));
        }

        public boolean contains(Module module2) {
            return this.getModuleNames().contains(module2.getName());
        }

        public void add(Module module2) {
            this.modules = StringUtil.isEmpty((String)this.modules) ? module2.getName() : this.modules + "\n" + module2.getName();
        }

        public void remove(String value2) {
            ArrayList<String> names = new ArrayList<String>(this.getModuleNames());
            names.remove(value2);
            this.modules = StringUtil.join(names, (String)"\n");
        }
    }

    private class MyCellRenderer
    extends ColoredTreeCellRenderer {
        private MyCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/ImageDuplicateResultsDialog$MyCellRenderer", "customizeCellRenderer"));
            }
            if (value2 instanceof MyFileNode) {
                VirtualFile file2 = ((MyFileNode)value2).getUserObject();
                Module module2 = ModuleUtil.findModuleForFile((VirtualFile)file2, (Project)ImageDuplicateResultsDialog.this.myProject);
                if (module2 != null) {
                    this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
                    this.append("[" + module2.getName() + "] ", new SimpleTextAttributes(1, UIUtil.getTreeForeground()));
                    this.append(ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file2));
                } else {
                    this.append(ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file2));
                }
            } else if (value2 instanceof MyDuplicatesNode) {
                Object files = ((MyDuplicatesNode)value2).getUserObject();
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    VirtualFile file3 = (VirtualFile)iterator.next();
                    Module module3 = ModuleUtil.findModuleForFile((VirtualFile)file3, (Project)ImageDuplicateResultsDialog.this.myProject);
                    if (module3 == null || !ImageDuplicateResultsDialog.this.myResourceModules.contains(module3)) continue;
                    this.append("Icons can be replaced to ");
                    this.append(ImageDuplicateResultsDialog.getRelativePathToProject(ImageDuplicateResultsDialog.this.myProject, file3), new SimpleTextAttributes(1, ColorUtil.fromHex((String)"008000")));
                    return;
                }
                this.append("Icon conflict");
            } else if (value2 instanceof MyRootNode) {
                this.append("All conflicts");
            }
        }
    }

    private static class MyFileNode
    extends DefaultMutableTreeNode {
        public MyFileNode(DefaultMutableTreeNode node, VirtualFile file2) {
            super(file2);
            this.setParent(node);
        }

        public VirtualFile getUserObject() {
            return (VirtualFile)super.getUserObject();
        }
    }

    private static class MyDuplicatesNode
    extends DefaultMutableTreeNode {
        public MyDuplicatesNode(DefaultMutableTreeNode node, Set<VirtualFile> files) {
            super(files);
            this.setParent(node);
            this.children = files.stream().map(file2 -> new MyFileNode(this, (VirtualFile)file2)).collect(Collectors.toCollection(Vector::new));
        }

        @Override
        public Set<VirtualFile> getUserObject() {
            return (Set)super.getUserObject();
        }
    }

    private class MyRootNode
    extends DefaultMutableTreeNode {
        private MyRootNode() {
            this.children = ImageDuplicateResultsDialog.this.myDuplicates.values().stream().map(files -> new MyDuplicatesNode(this, (Set<VirtualFile>)files)).collect(Collectors.toCollection(Vector::new));
        }
    }
}

