/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class OsVersionUsageCollector
extends UsagesCollector {
    OsVersionUsageCollector() {
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        UsageDescriptor descriptor;
        if (SystemInfo.isLinux) {
            Version version;
            String releaseId = null;
            String releaseVersion = null;
            try {
                Map<String, String> values = Files.lines(Paths.get("/etc/os-release", new String[0])).map(line -> StringUtil.split((String)line, (String)"=")).filter(parts -> parts.size() == 2).collect(Collectors.toMap(parts -> (String)parts.get(0), parts -> StringUtil.unquoteString((String)((String)parts.get(1)))));
                releaseId = values.get("ID");
                releaseVersion = values.get("VERSION_ID");
            }
            catch (IOException values) {
                // empty catch block
            }
            if (releaseId == null) {
                releaseId = "unknown";
            }
            if (releaseVersion == null && (version = Version.parseVersion((String)(releaseVersion = SystemInfo.OS_VERSION))) != null) {
                releaseVersion = version.toCompactString();
            }
            descriptor = new UsageDescriptor("Linux/" + releaseId + " " + releaseVersion, 1);
        } else {
            descriptor = new UsageDescriptor(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, 1);
        }
        Set<UsageDescriptor> set2 = Collections.singleton(descriptor);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/OsVersionUsageCollector", "getUsages"));
        }
        return set2;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("user.os.version");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/OsVersionUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

