/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibrarySupport;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryAddLibraryAction
extends IntentionAndQuickFixAction {
    private final Module module;
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;

    public RepositoryAddLibraryAction(Module module2, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "com/intellij/jarRepository/RepositoryAddLibraryAction", "<init>"));
        }
        this.module = module2;
        this.libraryDescription = libraryDescription;
    }

    @NotNull
    public String getName() {
        String string = "Add " + this.libraryDescription.getDisplayName() + " library to module dependencies";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryAddLibraryAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Maven libraries" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/RepositoryAddLibraryAction", "getFamilyName"));
        }
        return "Maven libraries";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, PsiFile file2, @Nullable Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jarRepository/RepositoryAddLibraryAction", "applyFix"));
        }
        RepositoryAddLibraryAction.addLibraryToModule(this.libraryDescription, this.module);
    }

    public static void addLibraryToModule(RepositoryLibraryDescription libraryDescription, Module module2) {
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel("RELEASE", false, false);
        RepositoryLibraryPropertiesDialog dialog2 = new RepositoryLibraryPropertiesDialog(module2.getProject(), model, libraryDescription, false);
        if (!dialog2.showAndGet()) {
            return;
        }
        IdeaModifiableModelsProvider modifiableModelsProvider = new IdeaModifiableModelsProvider();
        ModifiableRootModel modifiableModel = modifiableModelsProvider.getModuleModifiableModel(module2);
        RepositoryLibrarySupport librarySupport = new RepositoryLibrarySupport(module2.getProject(), libraryDescription, model);
        assert (modifiableModel != null);
        librarySupport.addSupport(module2, modifiableModel, modifiableModelsProvider);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
    }
}

