/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services;

import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.artifactory.ArtifactoryRepositoryService;
import com.intellij.jarRepository.services.nexus.NexusRepositoryService;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="MavenServices", storages={@Storage(value="mavenServices.xml")})
public class MavenRepositoryServicesManager
implements PersistentStateComponent<MavenRepositoryServicesManager> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.repository.services.MavenRepositoryServicesManager");
    private final List<String> myUrls = new ArrayList<String>();
    public static final List<String> DEFAULT_SERVICES = Collections.unmodifiableList(Arrays.asList("https://oss.sonatype.org/service/local/", "http://repo.jfrog.org/artifactory/api/", "https://repository.jboss.org/nexus/service/local/"));

    public MavenRepositoryServicesManager() {
        for (String s : DEFAULT_SERVICES) {
            this.myUrls.add(s);
        }
    }

    @NotNull
    public static MavenRepositoryServicesManager getInstance(Project project2) {
        MavenRepositoryServicesManager mavenRepositoryServicesManager = (MavenRepositoryServicesManager)ServiceManager.getService((Project)project2, MavenRepositoryServicesManager.class);
        if (mavenRepositoryServicesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "getInstance"));
        }
        return mavenRepositoryServicesManager;
    }

    @NotNull
    public static MavenRepositoryService[] getServices() {
        MavenRepositoryService[] mavenRepositoryServiceArray = new MavenRepositoryService[]{new NexusRepositoryService(), new ArtifactoryRepositoryService()};
        if (mavenRepositoryServiceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "getServices"));
        }
        return mavenRepositoryServiceArray;
    }

    public static String[] getServiceUrls(Project project2) {
        return ArrayUtil.toStringArray(MavenRepositoryServicesManager.getInstance(project2).getUrls());
    }

    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="service-url", elementValueAttribute="")
    @NotNull
    public List<String> getUrls() {
        List<String> list2 = this.myUrls;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "getUrls"));
        }
        return list2;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "setUrls"));
        }
        if (this.myUrls != urls) {
            this.myUrls.clear();
            this.myUrls.addAll(urls);
        }
    }

    public MavenRepositoryServicesManager getState() {
        return this;
    }

    public void loadState(MavenRepositoryServicesManager state) {
        this.myUrls.clear();
        this.myUrls.addAll(state.getUrls());
    }

    @NotNull
    public static List<RemoteRepositoryDescription> getRepositories(String url) {
        SmartList result2 = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result2.addAll(service.getRepositories(url));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "getRepositories"));
        }
        return smartList;
    }

    @NotNull
    public static List<RepositoryArtifactDescription> findArtifacts(@NotNull RepositoryArtifactDescription template, @NotNull String url) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        SmartList result2 = new SmartList();
        for (MavenRepositoryService service : MavenRepositoryServicesManager.getServices()) {
            try {
                result2.addAll(service.findArtifacts(url, template));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jarRepository/services/MavenRepositoryServicesManager", "findArtifacts"));
        }
        return smartList;
    }
}

