/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocHelper {
    private static final String PARAM_TEXT = "param";
    private static final Pair<JavadocParameterInfo, List<JavadocParameterInfo>> EMPTY = new Pair(null, Collections.emptyList());
    private static final JavadocHelper INSTANCE = new JavadocHelper();

    @NotNull
    public static JavadocHelper getInstance() {
        JavadocHelper javadocHelper = INSTANCE;
        if (javadocHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocHelper", "getInstance"));
        }
        return javadocHelper;
    }

    public void navigate(@NotNull LogicalPosition position, @NotNull Editor editor, @NotNull Project project2) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/javadoc/JavadocHelper", "navigate"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javadoc/JavadocHelper", "navigate"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javadoc/JavadocHelper", "navigate"));
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int endLineOffset = document.getLineEndOffset(position.line);
        LogicalPosition endLinePosition = editor.offsetToLogicalPosition(endLineOffset);
        if (endLinePosition.column < position.column && !editor.getSettings().isVirtualSpace() && !editor.isViewer()) {
            String toInsert = StringUtil.repeat((String)" ", (int)(position.column - endLinePosition.column));
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javadoc/JavadocHelper", "lambda$navigate$0"));
                }
                document.insertString(endLineOffset, (CharSequence)toInsert);
                PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            });
        }
        caretModel.moveToLogicalPosition(position);
    }

    @NotNull
    public LogicalPosition calculateDescriptionStartPosition(@NotNull PsiFile psiFile, @NotNull Collection<JavadocParameterInfo> data, @NotNull JavadocParameterInfo anchor) {
        int column;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javadoc/JavadocHelper", "calculateDescriptionStartPosition"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/javadoc/JavadocHelper", "calculateDescriptionStartPosition"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/javadoc/JavadocHelper", "calculateDescriptionStartPosition"));
        }
        int descriptionStartColumn = -1;
        int parameterNameEndColumn = -1;
        for (JavadocParameterInfo parameterInfo : data) {
            parameterNameEndColumn = Math.max(parameterNameEndColumn, parameterInfo.parameterNameEndPosition.column);
            if (parameterInfo.parameterDescriptionStartPosition == null) continue;
            descriptionStartColumn = Math.max(descriptionStartColumn, parameterInfo.parameterDescriptionStartPosition.column);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)psiFile.getProject()).getCurrentSettings();
        if (codeStyleSettings.JD_ALIGN_PARAM_COMMENTS) {
            column = Math.max(descriptionStartColumn, parameterNameEndColumn);
            if (column <= parameterNameEndColumn) {
                column = parameterNameEndColumn + 1;
            }
        } else {
            column = anchor.parameterNameEndPosition.column + 1;
        }
        LogicalPosition logicalPosition = new LogicalPosition(anchor.parameterNameEndPosition.line, column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocHelper", "calculateDescriptionStartPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public Pair<JavadocParameterInfo, List<JavadocParameterInfo>> parse(@NotNull PsiFile psiFile, @NotNull Editor editor, int offset) {
        JavadocParameterInfo info;
        PsiElement e;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javadoc/JavadocHelper", "parse"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javadoc/JavadocHelper", "parse"));
        }
        ArrayList<JavadocParameterInfo> result2 = new ArrayList<JavadocParameterInfo>();
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(editor.getDocument());
        PsiElement elementAtCaret = psiFile.findElementAt(offset);
        if (elementAtCaret == null) {
            Pair<JavadocParameterInfo, List<JavadocParameterInfo>> pair2 = EMPTY;
            if (pair2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocHelper", "parse"));
            }
            return pair2;
        }
        PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiDocTag.class);
        if (tag == null && elementAtCaret instanceof PsiWhiteSpace) {
            for (PsiElement e2 = elementAtCaret.getPrevSibling(); e2 != null && tag == null; e2 = e2.getPrevSibling()) {
                tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)e2, PsiDocTag.class, (boolean)false);
                if (!(e2 instanceof PsiWhiteSpace) && (!(e2 instanceof PsiDocToken) || ((PsiDocToken)e2).getTokenType() != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS)) break;
            }
        }
        if (tag == null) {
            Pair<JavadocParameterInfo, List<JavadocParameterInfo>> pair3 = EMPTY;
            if (pair3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocHelper", "parse"));
            }
            return pair3;
        }
        JavadocParameterInfo anchorInfo = JavadocHelper.parse((PsiElement)tag, editor);
        if (anchorInfo == null) {
            Pair<JavadocParameterInfo, List<JavadocParameterInfo>> pair4 = EMPTY;
            if (pair4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocHelper", "parse"));
            }
            return pair4;
        }
        for (e = tag.getPrevSibling(); e != null && (info = JavadocHelper.parse(e, editor)) != null; e = e.getPrevSibling()) {
            result2.add(0, info);
        }
        result2.add(anchorInfo);
        for (e = tag.getNextSibling(); e != null && (info = JavadocHelper.parse(e, editor)) != null; e = e.getNextSibling()) {
            result2.add(info);
        }
        Pair pair5 = Pair.create((Object)anchorInfo, result2);
        if (pair5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javadoc/JavadocHelper", "parse"));
        }
        return pair5;
    }

    @Nullable
    private static JavadocParameterInfo parse(@NotNull PsiElement element, @NotNull Editor editor) {
        ASTNode node;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javadoc/JavadocHelper", "parse"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javadoc/JavadocHelper", "parse"));
        }
        PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class, (boolean)false);
        if (tag == null || !PARAM_TEXT.equals(tag.getName())) {
            return null;
        }
        PsiDocTagValue paramRef = (PsiDocTagValue)PsiTreeUtil.getChildOfType((PsiElement)tag, PsiDocTagValue.class);
        if (paramRef == null) {
            return null;
        }
        for (PsiElement e = paramRef.getNextSibling(); e != null && (node = e.getNode()) != null; e = e.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaDocTokenType.DOC_COMMENT_DATA) {
                return new JavadocParameterInfo(editor.offsetToLogicalPosition(paramRef.getTextRange().getEndOffset()), editor.offsetToLogicalPosition(e.getTextRange().getStartOffset()), editor.getDocument().getLineNumber(e.getTextRange().getEndOffset()));
            }
            if (elementType == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) break;
        }
        return new JavadocParameterInfo(editor.offsetToLogicalPosition(paramRef.getTextRange().getEndOffset()), null, editor.getDocument().getLineNumber(paramRef.getTextRange().getEndOffset()));
    }

    public static class JavadocParameterInfo {
        @NotNull
        public final LogicalPosition parameterNameEndPosition;
        @Nullable
        public final LogicalPosition parameterDescriptionStartPosition;
        public final int lastLine;

        public JavadocParameterInfo(@NotNull LogicalPosition parameterNameEndPosition, LogicalPosition parameterDescriptionStartPosition, int lastLine) {
            if (parameterNameEndPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterNameEndPosition", "com/intellij/javadoc/JavadocHelper$JavadocParameterInfo", "<init>"));
            }
            this.parameterNameEndPosition = parameterNameEndPosition;
            this.parameterDescriptionStartPosition = parameterDescriptionStartPosition;
            this.lastLine = lastLine;
        }

        public String toString() {
            return "name end: " + this.parameterNameEndPosition + ", description start: " + this.parameterDescriptionStartPosition;
        }
    }
}

