/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingRegionsPopup {
    @NotNull
    private final JBList<MyFoldingDescriptorWrapper> myRegionsList;
    @NotNull
    private final JBPopup myPopup;
    @NotNull
    private final Editor myEditor;

    CustomFoldingRegionsPopup(@NotNull Collection<FoldingDescriptor> descriptors, @NotNull Editor editor, @NotNull Project project2) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup", "<init>"));
        }
        this.myEditor = editor;
        this.myRegionsList = new JBList();
        this.myRegionsList.setModel((ListModel)new MyListModel(descriptors));
        this.myRegionsList.setSelectedIndex(0);
        PopupChooserBuilder popupBuilder = JBPopupFactory.getInstance().createListPopupBuilder(this.myRegionsList);
        this.myPopup = popupBuilder.setTitle(IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0])).setResizable(false).setMovable(false).setItemChoosenCallback(() -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup", "lambda$new$0"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup", "lambda$new$0"));
            }
            PsiElement navigationElement = this.getNavigationElement();
            if (navigationElement != null) {
                CustomFoldingRegionsPopup.navigateTo(editor, navigationElement);
                IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            }
        }).createPopup();
    }

    void show() {
        this.myPopup.showInBestPositionFor(this.myEditor);
    }

    @Nullable
    public PsiElement getNavigationElement() {
        Object selection = this.myRegionsList.getSelectedValue();
        if (selection != null) {
            return ((MyFoldingDescriptorWrapper)selection).getDescriptor().getElement().getPsi();
        }
        return null;
    }

    private static Collection<FoldingDescriptor> orderByPosition(Collection<FoldingDescriptor> descriptors) {
        ArrayList<FoldingDescriptor> sorted = new ArrayList<FoldingDescriptor>(descriptors.size());
        sorted.addAll(descriptors);
        Collections.sort(sorted, (descriptor1, descriptor2) -> {
            int pos1 = descriptor1.getElement().getTextRange().getStartOffset();
            int pos2 = descriptor2.getElement().getTextRange().getStartOffset();
            return pos1 - pos2;
        });
        return sorted;
    }

    private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup", "navigateTo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup", "navigateTo"));
        }
        int offset = element.getTextRange().getStartOffset();
        if (offset >= 0 && offset < editor.getDocument().getTextLength()) {
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            editor.getSelectionModel().removeSelection();
        }
    }

    private static class MyFoldingDescriptorWrapper {
        @NotNull
        private final FoldingDescriptor myDescriptor;
        private final int myIndent;

        private MyFoldingDescriptorWrapper(@NotNull FoldingDescriptor descriptor, int indent) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup$MyFoldingDescriptorWrapper", "<init>"));
            }
            this.myDescriptor = descriptor;
            this.myIndent = indent;
        }

        @NotNull
        public FoldingDescriptor getDescriptor() {
            FoldingDescriptor foldingDescriptor = this.myDescriptor;
            if (foldingDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/customFolding/CustomFoldingRegionsPopup$MyFoldingDescriptorWrapper", "getDescriptor"));
            }
            return foldingDescriptor;
        }

        @Nullable
        public String toString() {
            return StringUtil.repeat((String)"   ", (int)this.myIndent) + this.myDescriptor.getPlaceholderText();
        }
    }

    private static class MyListModel
    extends DefaultListModel<MyFoldingDescriptorWrapper> {
        private MyListModel(Collection<FoldingDescriptor> descriptors) {
            descriptors = CustomFoldingRegionsPopup.orderByPosition(descriptors);
            Stack<FoldingDescriptor> stack = new Stack<FoldingDescriptor>();
            for (FoldingDescriptor descriptor : descriptors) {
                while (!stack.isEmpty() && descriptor.getRange().getStartOffset() >= ((FoldingDescriptor)stack.peek()).getRange().getEndOffset()) {
                    stack.pop();
                }
                super.addElement(new MyFoldingDescriptorWrapper(descriptor, stack.size()));
                stack.push(descriptor);
            }
        }
    }
}

