/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlQuotesFormatPreprocessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
        }
        PsiElement psiElement = node.getPsi();
        if (psiElement != null && psiElement.isValid() && psiElement.getLanguage().is((Language)HTMLLanguage.INSTANCE)) {
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)psiElement.getProject());
            CodeStyleSettings.QuoteStyle quoteStyle = settings.HTML_QUOTE_STYLE;
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None && settings.HTML_ENFORCE_QUOTES) {
                PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper((CommonCodeStyleSettings)settings);
                postFormatProcessorHelper.setResultTextRange(range);
                HtmlQuotesConverter converter = new HtmlQuotesConverter(quoteStyle, psiElement, postFormatProcessorHelper);
                Document document = converter.getDocument();
                if (document != null) {
                    DocumentUtil.executeInBulk(document, true, converter);
                }
                TextRange textRange = postFormatProcessorHelper.getResultTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
                }
                return textRange;
            }
        }
        TextRange textRange = range;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor", "process"));
        }
        return textRange;
    }

    public static class HtmlQuotesConverter
    extends XmlRecursiveElementVisitor
    implements Runnable {
        private TextRange myOriginalRange;
        private final Document myDocument;
        private final PsiDocumentManager myDocumentManager;
        private final PostFormatProcessorHelper myPostProcessorHelper;
        private final PsiElement myContext;
        private final char myQuoteChar;

        public HtmlQuotesConverter(@NotNull CodeStyleSettings.QuoteStyle style, @NotNull PsiElement context, @NotNull PostFormatProcessorHelper postFormatProcessorHelper) {
            if (style == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "<init>"));
            }
            if (postFormatProcessorHelper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postFormatProcessorHelper", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "<init>"));
            }
            this.myPostProcessorHelper = postFormatProcessorHelper;
            Project project2 = context.getProject();
            PsiFile file2 = context.getContainingFile();
            this.myContext = context;
            this.myOriginalRange = postFormatProcessorHelper.getResultTextRange();
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            this.myDocument = this.myDocumentManager.getDocument(file2);
            switch (style) {
                case Single: {
                    this.myQuoteChar = (char)39;
                    break;
                }
                case Double: {
                    this.myQuoteChar = (char)34;
                    break;
                }
                default: {
                    this.myQuoteChar = '\u0000';
                }
            }
        }

        public Document getDocument() {
            return this.myDocument;
        }

        public void visitXmlAttributeValue(XmlAttributeValue value2) {
            PsiElement child;
            if (this.myOriginalRange.contains(value2.getTextRange()) && (child = value2.getFirstChild()) != null && !this.containsQuoteChars(value2)) {
                String newValue = null;
                if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    char existingQuote;
                    CharSequence delimiterChars;
                    PsiElement lastChild = value2.getLastChild();
                    if (lastChild != null && lastChild.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && (delimiterChars = child.getNode().getChars()).length() == 1 && (existingQuote = delimiterChars.charAt(0)) != this.myQuoteChar) {
                        newValue = this.convertQuotes(value2);
                    }
                } else if (child.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && child == value2.getLastChild()) {
                    newValue = this.surroundWithQuotes(value2);
                }
                if (newValue != null) {
                    TextRange range = this.myPostProcessorHelper.mapRange(value2.getTextRange());
                    this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newValue);
                    this.myPostProcessorHelper.updateResultRange(value2.getTextLength(), newValue.length());
                }
            }
        }

        @Nullable
        private String convertQuotes(@NotNull XmlAttributeValue value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "convertQuotes"));
            }
            String currValue = value2.getNode().getChars().toString();
            if (currValue.length() >= 2) {
                return this.myQuoteChar + currValue.substring(1, currValue.length() - 1) + this.myQuoteChar;
            }
            return null;
        }

        @NotNull
        private String surroundWithQuotes(@NotNull XmlAttributeValue value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "surroundWithQuotes"));
            }
            String currValue = value2.getNode().getChars().toString();
            String string = this.myQuoteChar + currValue + this.myQuoteChar;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "surroundWithQuotes"));
            }
            return string;
        }

        private boolean containsQuoteChars(@NotNull XmlAttributeValue value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "containsQuoteChars"));
            }
            for (PsiElement child = value2.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (HtmlQuotesConverter.isDelimiter(child.getNode().getElementType())) continue;
                CharSequence valueChars = child.getNode().getChars();
                for (int i2 = 0; i2 < valueChars.length(); ++i2) {
                    if (valueChars.charAt(i2) != this.myQuoteChar) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isDelimiter(@NotNull IElementType elementType) {
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "isDelimiter"));
            }
            return elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
        }

        @Override
        public void run() {
            if (this.myDocument != null) {
                this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.myContext.accept((PsiElementVisitor)this);
                this.myDocumentManager.commitDocument(this.myDocument);
            }
        }

        public static void runOnElement(@NotNull CodeStyleSettings.QuoteStyle quoteStyle, @NotNull PsiElement element) {
            if (quoteStyle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteStyle", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "runOnElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/html/HtmlQuotesFormatPreprocessor$HtmlQuotesConverter", "runOnElement"));
            }
            PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(null);
            postFormatProcessorHelper.setResultTextRange(element.getTextRange());
            new HtmlQuotesConverter(quoteStyle, element, postFormatProcessorHelper).run();
        }
    }
}

