/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PrattBuilder;
import com.intellij.lang.pratt.PrattTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;

public class PrattParsingUtil {
    private PrattParsingUtil() {
    }

    public static void searchFor(PrattBuilder builder, PrattTokenType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/pratt/PrattParsingUtil", "searchFor"));
        }
        PrattParsingUtil.searchFor(builder, true, types);
    }

    public static boolean searchFor(PrattBuilder builder, boolean consume, PrattTokenType ... types) {
        TokenSet set2 = TokenSet.create((IElementType[])types);
        if (!set2.contains(builder.getTokenType())) {
            builder.assertToken(types[0]);
            while (!set2.contains(builder.getTokenType()) && !builder.isEof()) {
                builder.advance();
            }
        }
        if (consume) {
            builder.advance();
        }
        return !builder.isEof();
    }

    @Nullable
    public static IElementType parseOption(PrattBuilder builder, int rightPriority) {
        MutableMarker marker = builder.mark();
        IElementType type2 = builder.createChildBuilder(rightPriority).parse();
        if (type2 == null) {
            marker.rollback();
        } else {
            marker.finish();
        }
        return type2;
    }
}

