/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMLExternalAnnotator
extends ExternalAnnotator<MyHost, MyHost> {
    @Nullable
    public MyHost collectInformation(@NotNull PsiFile file2) {
        XmlNSDescriptor nsDescriptor;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/xml/XMLExternalAnnotator", "collectInformation"));
        }
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file2).getDocument();
        if (document == null) {
            return null;
        }
        XmlTag rootTag = document.getRootTag();
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = rootTag == null ? null : rootTag.getNSDescriptor(rootTag.getNamespace(), false);
        if (nsDescriptor instanceof Validator) {
            MyHost host = new MyHost();
            ((Validator)nsDescriptor).validate(document, host);
            return host;
        }
        return null;
    }

    @Nullable
    public MyHost doAnnotate(MyHost collectedInfo) {
        return collectedInfo;
    }

    public void apply(@NotNull PsiFile file2, MyHost annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/xml/XMLExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/xml/XMLExternalAnnotator", "apply"));
        }
        annotationResult.apply(holder);
    }

    private static void appendFixes(Annotation annotation, IntentionAction ... actions) {
        if (actions != null) {
            for (IntentionAction action : actions) {
                annotation.registerFix(action);
            }
        }
    }

    public static void addMessageWithFixes(PsiElement context, String message2, @NotNull Validator.ValidationHost.ErrorType type2, AnnotationHolder myHolder, IntentionAction ... fixes) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/xml/XMLExternalAnnotator", "addMessageWithFixes"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/xml/XMLExternalAnnotator", "addMessageWithFixes"));
        }
        if (message2 != null && !message2.isEmpty()) {
            if (context instanceof XmlTag) {
                XMLExternalAnnotator.addMessagesForTag((XmlTag)context, message2, type2, myHolder, fixes);
            } else if (type2 == Validator.ValidationHost.ErrorType.ERROR) {
                XMLExternalAnnotator.appendFixes(myHolder.createErrorAnnotation(context, message2), fixes);
            } else {
                XMLExternalAnnotator.appendFixes(myHolder.createWarningAnnotation(context, message2), fixes);
            }
        }
    }

    private static void addMessagesForTag(XmlTag tag, String message2, Validator.ValidationHost.ErrorType type2, AnnotationHolder myHolder, IntentionAction ... actions) {
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        XMLExternalAnnotator.addMessagesForTreeChild(childByRole, type2, message2, myHolder, actions);
        childByRole = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
        XMLExternalAnnotator.addMessagesForTreeChild(childByRole, type2, message2, myHolder, actions);
    }

    private static void addMessagesForTreeChild(XmlToken childByRole, Validator.ValidationHost.ErrorType type2, String message2, AnnotationHolder myHolder, IntentionAction ... actions) {
        if (childByRole != null) {
            Annotation annotation = type2 == Validator.ValidationHost.ErrorType.ERROR ? myHolder.createErrorAnnotation((PsiElement)childByRole, message2) : myHolder.createWarningAnnotation((PsiElement)childByRole, message2);
            XMLExternalAnnotator.appendFixes(annotation, actions);
        }
    }

    static class MyHost
    implements Validator.ValidationHost {
        private final List<Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>> messages = new ArrayList<Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>>();

        MyHost() {
        }

        @Override
        public void addMessage(PsiElement context, String message2, int type2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addMessage(PsiElement context, String message2, @NotNull Validator.ValidationHost.ErrorType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/xml/XMLExternalAnnotator$MyHost", "addMessage"));
            }
            this.messages.add((Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>)Trinity.create((Object)context, (Object)message2, (Object)((Object)type2)));
        }

        void apply(AnnotationHolder holder) {
            for (Trinity<PsiElement, String, Validator.ValidationHost.ErrorType> message2 : this.messages) {
                XMLExternalAnnotator.addMessageWithFixes((PsiElement)message2.first, (String)message2.second, (Validator.ValidationHost.ErrorType)((Object)message2.third), holder, new IntentionAction[0]);
            }
        }
    }
}

