/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class MockApplication
extends MockComponentManager
implements Application {
    public static int INSTANCES_CREATED = 0;

    public MockApplication(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockApplication", "<init>"));
        }
        super(null, parentDisposable);
        ++INSTANCES_CREATED;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isEAP() {
        return false;
    }

    public boolean isDispatchThread() {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public void assertReadAccessAllowed() {
    }

    public void assertWriteAccessAllowed() {
    }

    public void assertIsDispatchThread() {
    }

    public boolean isReadAccessAllowed() {
        return true;
    }

    public boolean isWriteAccessAllowed() {
        return true;
    }

    public boolean isUnitTestMode() {
        return true;
    }

    public boolean isHeadlessEnvironment() {
        return true;
    }

    public boolean isCommandLine() {
        return true;
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        Future<?> future2 = PooledThreadExecutor.INSTANCE.submit(action);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        return future2;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(@NotNull Callable<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        Future<T> future2 = PooledThreadExecutor.INSTANCE.submit(action);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        return future2;
    }

    public boolean isDisposeInProgress() {
        return false;
    }

    public boolean isRestartCapable() {
        return false;
    }

    public void restart() {
    }

    public void runReadAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "runReadAction"));
        }
        action.run();
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runReadAction"));
        }
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runReadAction"));
        }
        return (T)computation.compute();
    }

    public void runWriteAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "runWriteAction"));
        }
        action.run();
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runWriteAction"));
        }
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runWriteAction"));
        }
        return (T)computation.compute();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "acquireReadActionLock"));
        }
        return accessToken;
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@Nullable Class marker) {
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "acquireWriteActionLock"));
        }
        return accessToken;
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        if (actionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionClass", "com/intellij/mock/MockApplication", "hasWriteAction"));
        }
        return false;
    }

    public void addApplicationListener(@NotNull ApplicationListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockApplication", "addApplicationListener"));
        }
    }

    public void addApplicationListener(@NotNull ApplicationListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockApplication", "addApplicationListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/mock/MockApplication", "addApplicationListener"));
        }
    }

    public void removeApplicationListener(@NotNull ApplicationListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockApplication", "removeApplicationListener"));
        }
    }

    public long getStartTime() {
        return 0L;
    }

    public long getIdleTime() {
        return 0L;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        ModalityState modalityState = ModalityState.NON_MODAL;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getNoneModalityState"));
        }
        return modalityState;
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition expired) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        throw new UnsupportedOperationException();
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeAndWait"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/mock/MockApplication", "invokeAndWait"));
        }
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeAndWait"));
        }
        this.invokeAndWait(runnable2, this.getDefaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getCurrentModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getAnyModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/mock/MockApplication", "getModalityStateForComponent"));
        }
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getModalityStateForComponent"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getDefaultModalityState"));
        }
        return modalityState;
    }

    public void exit() {
    }

    public void saveAll() {
    }

    public void saveSettings() {
    }
}

