/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileDocumentManagerImpl
extends FileDocumentManager {
    private static final Key<VirtualFile> MOCK_VIRTUAL_FILE_KEY = Key.create((String)"MockVirtualFile");
    private final Function<CharSequence, Document> myFactory;
    @Nullable
    private final Key<Document> myCachedDocumentKey;
    private static final Key<Document> MOCK_DOC_KEY = Key.create((String)"MOCK_DOC_KEY");

    public MockFileDocumentManagerImpl(Function<CharSequence, Document> factory, @Nullable Key<Document> cachedDocumentKey) {
        this.myFactory = factory;
        this.myCachedDocumentKey = cachedDocumentKey;
    }

    private static boolean isBinaryWithoutDecompiler(VirtualFile file2) {
        FileType ft = file2.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) == null;
    }

    public Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileDocumentManagerImpl", "getDocument"));
        }
        Document document = (Document)file2.getUserData(MOCK_DOC_KEY);
        if (document == null) {
            if (file2.isDirectory() || MockFileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            CharSequence text2 = LoadTextUtil.loadText(file2);
            document = (Document)this.myFactory.fun((Object)text2);
            document.putUserData(MOCK_VIRTUAL_FILE_KEY, (Object)file2);
            document = (Document)file2.putUserDataIfAbsent(MOCK_DOC_KEY, (Object)document);
        }
        return document;
    }

    public Document getCachedDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileDocumentManagerImpl", "getCachedDocument"));
        }
        if (this.myCachedDocumentKey != null) {
            return (Document)file2.getUserData(this.myCachedDocumentKey);
        }
        return null;
    }

    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/mock/MockFileDocumentManagerImpl", "getFile"));
        }
        return (VirtualFile)document.getUserData(MOCK_VIRTUAL_FILE_KEY);
    }

    public void saveAllDocuments() {
    }

    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/mock/MockFileDocumentManagerImpl", "saveDocument"));
        }
    }

    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/mock/MockFileDocumentManagerImpl", "saveDocumentAsIs"));
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        if (Document.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileDocumentManagerImpl", "getUnsavedDocuments"));
        }
        return Document.EMPTY_ARRAY;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/mock/MockFileDocumentManagerImpl", "isDocumentUnsaved"));
        }
        return false;
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/mock/MockFileDocumentManagerImpl", "isFileModified"));
        }
        return false;
    }

    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/mock/MockFileDocumentManagerImpl", "reloadFromDisk"));
        }
    }

    public void reloadFiles(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/mock/MockFileDocumentManagerImpl", "reloadFiles"));
        }
    }

    @NotNull
    public String getLineSeparator(VirtualFile file2, Project project2) {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockFileDocumentManagerImpl", "getLineSeparator"));
        }
        return "";
    }

    public boolean requestWriting(@NotNull Document document, @Nullable Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/mock/MockFileDocumentManagerImpl", "requestWriting"));
        }
        return true;
    }
}

