/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationGroupBean;
import com.intellij.notification.impl.NotificationParentGroupBean;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationParentGroup {
    private static final ExtensionPointName<NotificationParentGroupBean> EP_NAME = ExtensionPointName.create((String)"com.intellij.notification.parentGroup");
    private static final ExtensionPointName<NotificationGroupBean> EP_CHILD_NAME = ExtensionPointName.create((String)"com.intellij.notification.group");
    private static Map<String, NotificationParentGroupBean> myParents;
    private static Map<NotificationParentGroupBean, List<NotificationParentGroupBean>> myChildren;
    private static Map<String, NotificationParentGroupBean> myGroupToParent;
    private static Map<String, String> myReplaceTitles;
    private static Map<String, String> myShortTitles;

    private static void prepareInfo() {
        if (myParents == null) {
            NotificationParentGroupBean parent;
            myParents = new HashMap<String, NotificationParentGroupBean>();
            NotificationParentGroupBean[] parents = (NotificationParentGroupBean[])EP_NAME.getExtensions();
            for (NotificationParentGroupBean notificationParentGroupBean : parents) {
                myParents.put(notificationParentGroupBean.id, notificationParentGroupBean);
            }
            myChildren = new HashMap<NotificationParentGroupBean, List<NotificationParentGroupBean>>();
            for (NotificationParentGroupBean notificationParentGroupBean : parents) {
                if (notificationParentGroupBean.parentId == null || (parent = myParents.get(notificationParentGroupBean.parentId)) == null) continue;
                List<NotificationParentGroupBean> children2 = myChildren.get((Object)parent);
                if (children2 == null) {
                    children2 = new ArrayList<NotificationParentGroupBean>();
                    myChildren.put(parent, children2);
                }
                children2.add(notificationParentGroupBean);
            }
            myGroupToParent = new HashMap<String, NotificationParentGroupBean>();
            myReplaceTitles = new HashMap<String, String>();
            myShortTitles = new HashMap<String, String>();
            for (AbstractExtensionPointBean abstractExtensionPointBean : (NotificationGroupBean[])EP_CHILD_NAME.getExtensions()) {
                parent = myParents.get(abstractExtensionPointBean.parentId);
                if (parent == null) continue;
                myGroupToParent.put(abstractExtensionPointBean.groupId, parent);
                if (abstractExtensionPointBean.replaceTitle != null) {
                    myReplaceTitles.put(abstractExtensionPointBean.groupId, abstractExtensionPointBean.replaceTitle);
                }
                if (abstractExtensionPointBean.shortTitle == null) continue;
                myShortTitles.put(abstractExtensionPointBean.groupId, abstractExtensionPointBean.shortTitle);
            }
        }
    }

    @Nullable
    public static String getReplaceTitle(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationParentGroup", "getReplaceTitle"));
        }
        NotificationParentGroup.prepareInfo();
        return myReplaceTitles.get(groupId);
    }

    @Nullable
    public static String getShortTitle(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/notification/impl/NotificationParentGroup", "getShortTitle"));
        }
        NotificationParentGroup.prepareInfo();
        return myShortTitles.get(groupId);
    }

    @NotNull
    public static List<NotificationParentGroupBean> getChildren(@NotNull NotificationParentGroupBean parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/notification/impl/NotificationParentGroup", "getChildren"));
        }
        NotificationParentGroup.prepareInfo();
        List<NotificationParentGroupBean> children2 = myChildren.get((Object)parent);
        List<Object> list2 = children2 == null ? Collections.emptyList() : children2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationParentGroup", "getChildren"));
        }
        return list2;
    }

    @NotNull
    public static Collection<NotificationParentGroupBean> getParents() {
        NotificationParentGroup.prepareInfo();
        Collection<NotificationParentGroupBean> collection = Collections.unmodifiableCollection(myParents.values());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/NotificationParentGroup", "getParents"));
        }
        return collection;
    }

    @Nullable
    public static NotificationParentGroupBean findParent(@NotNull NotificationSettings setting) {
        NotificationParentGroupBean parent;
        if (setting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/notification/impl/NotificationParentGroup", "findParent"));
        }
        NotificationParentGroup.prepareInfo();
        String groupId = setting.getGroupId();
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId);
        if (group == null) {
            parent = myGroupToParent.get(groupId);
        } else {
            String parentId = group.getParentId();
            if (parentId == null) {
                parent = myGroupToParent.get(group.getDisplayId());
                if (parent != null) {
                    group.setParentId(parent.id);
                }
            } else {
                parent = myParents.get(parentId);
            }
        }
        return parent;
    }
}

