/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ExtendableAction
extends AnAction {
    @NotNull
    private final ExtensionPointName<AnActionExtensionProvider> myExtensionPoint;

    public ExtendableAction(@NotNull ExtensionPointName<AnActionExtensionProvider> extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPoint", "com/intellij/openapi/actionSystem/ExtendableAction", "<init>"));
        }
        this.myExtensionPoint = extensionPoint;
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ExtendableAction", "update"));
        }
        e.getPresentation().copyFrom(this.getTemplatePresentation());
        AnActionExtensionProvider provider = this.getProvider(e);
        if (provider != null) {
            provider.update(e);
        } else {
            this.defaultUpdate(e);
        }
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ExtendableAction", "actionPerformed"));
        }
        AnActionExtensionProvider provider = this.getProvider(e);
        if (provider != null) {
            provider.actionPerformed(e);
        } else {
            this.defaultActionPerformed(e);
        }
    }

    @Nullable
    private AnActionExtensionProvider getProvider(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ExtendableAction", "getProvider"));
        }
        return (AnActionExtensionProvider)ContainerUtil.find((Object[])this.myExtensionPoint.getExtensions(), provider -> {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ExtendableAction", "lambda$getProvider$0"));
            }
            return provider.isActive(e);
        });
    }

    protected void defaultUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ExtendableAction", "defaultUpdate"));
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    protected void defaultActionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ExtendableAction", "defaultActionPerformed"));
        }
    }
}

