/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.Utils");
    @NonNls
    public static final String NOTHING_HERE = "Nothing here";
    public static final AnAction EMPTY_MENU_FILLER = new AnAction("Nothing here"){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(false);
            super.update(e);
        }
    };

    private Utils() {
    }

    private static void handleUpdateException(AnAction action, Presentation presentation, Throwable exc) {
        String id = ActionManager.getInstance().getId(action);
        if (id != null) {
            LOG.error("update failed for AnAction with ID=" + id, exc);
        } else {
            LOG.error("update failed for ActionGroup: " + action + "[" + presentation.getText() + "]", exc);
        }
    }

    @Deprecated
    public static void expandActionGroup(@NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, @NotNull DataContext context, String place, ActionManager actionManager) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(false, group, list2, presentationFactory, context, place, actionManager, false, group instanceof CompactActionGroup);
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, @NotNull DataContext context, String place, ActionManager actionManager) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context, place, actionManager, false, group instanceof CompactActionGroup);
    }

    @Deprecated
    public static void expandActionGroup(@NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context, @NotNull String place, ActionManager actionManager, boolean transparentOnly) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(false, group, list2, presentationFactory, context, place, actionManager, transparentOnly, false);
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context, @NotNull String place, ActionManager actionManager, boolean transparentOnly) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context, place, actionManager, transparentOnly, false);
    }

    @Deprecated
    public static void expandActionGroup(@NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context, @NotNull String place, ActionManager actionManager, boolean transparentOnly, boolean hideDisabled) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Utils.expandActionGroup(false, group, list2, presentationFactory, context, place, actionManager, transparentOnly, hideDisabled);
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<AnAction> list2, PresentationFactory presentationFactory, DataContext context, @NotNull String place, ActionManager actionManager, boolean transparentOnly, boolean hideDisabled) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/impl/Utils", "expandActionGroup"));
        }
        Presentation presentation = presentationFactory.getPresentation((AnAction)group);
        AnActionEvent e = new AnActionEvent(null, context, place, presentation, actionManager, 0);
        if (!Utils.doUpdate(isInModalContext, (AnAction)group, e, presentation)) {
            return;
        }
        if (!presentation.isVisible()) {
            return;
        }
        AnAction[] children2 = group.getChildren(e);
        for (int i = 0; i < children2.length; ++i) {
            AnAction child = children2[i];
            if (child == null) {
                String groupId = ActionManager.getInstance().getId((AnAction)group);
                LOG.error("action is null: i=" + i + " group=" + group + " group id=" + groupId);
                continue;
            }
            presentation = presentationFactory.getPresentation(child);
            AnActionEvent e1 = new AnActionEvent(null, context, place, presentation, actionManager, 0);
            e1.setInjectedContext(child.isInInjectedContext());
            if ((transparentOnly && child.isTransparentUpdate() || !transparentOnly) && !Utils.doUpdate(isInModalContext, child, e1, presentation) || !presentation.isVisible() || !presentation.isEnabled() && hideDisabled) continue;
            if (child instanceof ActionGroup) {
                boolean skip;
                ActionGroup actionGroup = (ActionGroup)child;
                boolean bl = skip = hideDisabled && !Utils.hasEnabledChildren(actionGroup, presentationFactory, context, place);
                if (skip) continue;
                if (actionGroup.isPopup()) {
                    if (actionGroup.disableIfNoVisibleChildren()) {
                        boolean visibleChildren = Utils.hasVisibleChildren(actionGroup, presentationFactory, context, place);
                        if (actionGroup.hideIfNoVisibleChildren() && !visibleChildren) continue;
                        presentation.setEnabled(actionGroup.canBePerformed(context) || visibleChildren);
                    }
                    list2.add(child);
                    continue;
                }
                Utils.expandActionGroup(isInModalContext, (ActionGroup)child, list2, presentationFactory, context, place, actionManager, false, hideDisabled);
                continue;
            }
            if (child instanceof Separator) {
                if (StringUtil.isEmpty((String)((Separator)child).getText()) && (list2.isEmpty() || list2.get(list2.size() - 1) instanceof Separator)) continue;
                list2.add(child);
                continue;
            }
            if (hideDisabled && !Utils.hasEnabledChildren((ActionGroup)new DefaultActionGroup(new AnAction[]{child}), presentationFactory, context, place)) continue;
            list2.add(child);
        }
    }

    @Deprecated
    private static boolean doUpdate(AnAction action, AnActionEvent e, Presentation presentation) {
        return Utils.doUpdate(false, action, e, presentation);
    }

    private static boolean doUpdate(boolean isInModalContext, AnAction action, AnActionEvent e, Presentation presentation) throws ProcessCanceledException {
        boolean result2;
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            result2 = !ActionUtil.performDumbAwareUpdate((boolean)isInModalContext, (AnAction)action, (AnActionEvent)e, (boolean)false);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable exc) {
            Utils.handleUpdateException(action, presentation, exc);
            return false;
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime > 10L && LOG.isDebugEnabled()) {
            LOG.debug("Action " + action + ": updated in " + (endTime - startTime) + " ms");
        }
        return result2;
    }

    private static boolean hasVisibleChildren(ActionGroup group, PresentationFactory factory, DataContext context, String place) {
        return Utils.hasChildrenWithState(group, factory, context, place, true, false);
    }

    private static boolean hasEnabledChildren(ActionGroup group, PresentationFactory factory, DataContext context, String place) {
        return Utils.hasChildrenWithState(group, factory, context, place, false, true);
    }

    private static boolean hasChildrenWithState(ActionGroup group, PresentationFactory factory, DataContext context, String place, boolean checkVisible, boolean checkEnabled) {
        if (group instanceof AlwaysVisibleActionGroup) {
            return true;
        }
        AnActionEvent event = new AnActionEvent(null, context, place, factory.getPresentation((AnAction)group), ActionManager.getInstance(), 0);
        event.setInjectedContext(group.isInInjectedContext());
        for (AnAction anAction : group.getChildren(event)) {
            ActionGroup childGroup;
            Project project2;
            if (anAction == null) {
                LOG.error("Null action found in group " + group + ", " + factory.getPresentation((AnAction)group));
                continue;
            }
            if (anAction instanceof Separator || (project2 = (Project)CommonDataKeys.PROJECT.getData(context)) != null && DumbService.getInstance((Project)project2).isDumb() && !anAction.isDumbAware()) continue;
            Presentation presentation = factory.getPresentation(anAction);
            Utils.updateGroupChild(context, place, anAction, presentation);
            if (!(anAction instanceof ActionGroup ? !((childGroup = (ActionGroup)anAction).isPopup() && (checkVisible && !presentation.isVisible() || checkEnabled && !presentation.isEnabled()) || !Utils.hasChildrenWithState(childGroup, factory, context, place, checkVisible, checkEnabled)) : checkVisible && presentation.isVisible() || checkEnabled && presentation.isEnabled())) continue;
            return true;
        }
        return false;
    }

    public static void updateGroupChild(DataContext context, String place, AnAction anAction, Presentation presentation) {
        AnActionEvent event1 = new AnActionEvent(null, context, place, presentation, ActionManager.getInstance(), 0);
        event1.setInjectedContext(anAction.isInInjectedContext());
        Utils.doUpdate(false, anAction, event1, presentation);
    }

    @Deprecated
    public static void fillMenu(@NotNull ActionGroup group, JComponent component, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context, String place, boolean isWindowMenu, boolean mayDataContextBeInvalid) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        Utils.fillMenu(group, component, enableMnemonics, presentationFactory, context, place, isWindowMenu, mayDataContextBeInvalid, false);
    }

    public static void fillMenu(@NotNull ActionGroup group, final JComponent component, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context, String place, boolean isWindowMenu, boolean mayDataContextBeInvalid, boolean isInModalContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/actionSystem/impl/Utils", "fillMenu"));
        }
        ActionCallback menuBuilt = new ActionCallback();
        boolean checked = group instanceof CheckedActionGroup;
        ArrayList<AnAction> list2 = new ArrayList<AnAction>();
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context, place, ActionManager.getInstance());
        boolean fixMacScreenMenu = SystemInfo.isMacSystemMenu && isWindowMenu && Registry.is((String)"actionSystem.mac.screenMenuNotUpdatedFix");
        ArrayList<Object> children2 = new ArrayList<Object>();
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            AnAction action = list2.get(i);
            if (action instanceof Separator) {
                final String text2 = ((Separator)action).getText();
                if (StringUtil.isEmpty((String)text2) && (i <= 0 || i >= size - 1)) continue;
                component.add(new JPopupMenu.Separator(){
                    private final JMenuItem myMenu;
                    {
                        this.myMenu = !StringUtil.isEmpty((String)text2) ? new JMenuItem(text2) : null;
                    }

                    @Override
                    public Insets getInsets() {
                        Insets insets = super.getInsets();
                        boolean fix = UIUtil.isUnderGTKLookAndFeel() && this.getBorder() != null && insets.top + insets.bottom == 0;
                        return fix ? new Insets(2, insets.left, 3, insets.right) : insets;
                    }

                    @Override
                    public void doLayout() {
                        super.doLayout();
                        if (this.myMenu != null) {
                            this.myMenu.setBounds(this.getBounds());
                        }
                    }

                    @Override
                    protected void paintComponent(Graphics g) {
                        if (UIUtil.isUnderWindowsClassicLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderWindowsLookAndFeel() || UIUtil.isUnderWin10LookAndFeel()) {
                            g.setColor(component.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                        if (this.myMenu != null) {
                            this.myMenu.paint(g);
                        } else {
                            if (SystemInfo.isMac) {
                                Graphics2D g2 = (Graphics2D)g.create();
                                g2.setStroke(new BasicStroke(2.0f));
                                g2.setColor(UIUtil.AQUA_SEPARATOR_FOREGROUND_COLOR);
                                double y = (double)this.getHeight() / 2.0;
                                g2.draw(new Line2D.Double(0.0, y, this.getWidth(), y));
                                return;
                            }
                            super.paintComponent(g);
                        }
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return this.myMenu != null ? this.myMenu.getPreferredSize() : super.getPreferredSize();
                    }
                });
                continue;
            }
            if (action instanceof ActionGroup && (!((ActionGroup)action).canBePerformed(context) || Utils.hasVisibleChildren((ActionGroup)action, presentationFactory, context, place))) {
                ActionMenu menu = new ActionMenu(context, place, (ActionGroup)action, presentationFactory, enableMnemonics, false);
                component.add((Component)((Object)menu));
                children2.add((Object)menu);
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action, presentationFactory.getPresentation(action), place, context, enableMnemonics, !fixMacScreenMenu, checked);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (list2.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context, enableMnemonics, !fixMacScreenMenu, checked);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (fixMacScreenMenu) {
            SwingUtilities.invokeLater(() -> {
                for (Component each : children2) {
                    if (each.getParent() == null || !(each instanceof ActionMenuItem)) continue;
                    ((ActionMenuItem)((Object)((Object)each))).prepare();
                }
                menuBuilt.setDone();
            });
        } else {
            menuBuilt.setDone();
        }
        menuBuilt.doWhenDone(() -> {
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "lambda$fillMenu$2"));
            }
            if (!mayDataContextBeInvalid) {
                return;
            }
            if (IdeFocusManager.getInstance(null).isFocusBeingTransferred()) {
                IdeFocusManager.getInstance(null).doWhenFocusSettlesDown(() -> {
                    if (group == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/Utils", "lambda$null$1"));
                    }
                    if (!component.isShowing()) {
                        return;
                    }
                    DataContext context1 = DataManager.getInstance().getDataContext();
                    Utils.expandActionGroup(LaterInvocator.isInModalContext(), group, new ArrayList<AnAction>(), presentationFactory, context1, place, ActionManager.getInstance());
                    for (Component each : children2) {
                        if (each instanceof ActionMenuItem) {
                            ((ActionMenuItem)((Object)((Object)((Object)each)))).updateContext(context1);
                            continue;
                        }
                        if (!(each instanceof ActionMenu)) continue;
                        ((ActionMenu)((Object)((Object)((Object)each)))).updateContext(context1);
                    }
                });
            }
        });
    }
}

