/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.StringInterner;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStorageCoreUtil {
    private static final Logger LOG = Logger.getInstance(FileStorageCoreUtil.class);
    public static final String COMPONENT = "component";
    public static final String NAME = "name";
    public static final String DEFAULT_EXT = ".xml";

    @NotNull
    public static TreeMap<String, Element> load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil", "load"));
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        StringInterner interner = intern ? new StringInterner() : null;
        List children2 = rootElement.getChildren(COMPONENT);
        if (children2.isEmpty() && rootElement.getName().equals(COMPONENT) && rootElement.getAttributeValue(NAME) != null) {
            children2 = new SmartList((Object)rootElement);
        }
        CompositePathMacroFilter filter = null;
        TreeMap<String, Element> map2 = new TreeMap<String, Element>();
        Iterator iterator = children2.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String name2 = FileStorageCoreUtil.getComponentNameIfValid(element);
            if (name2 == null || element.getAttributes().size() <= 1 && element.getChildren().isEmpty()) continue;
            iterator.remove();
            if (interner != null) {
                JDOMUtil.internElement((Element)element, (StringInterner)interner);
            }
            map2.put(name2, element);
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                if (filter == null) {
                    filter = new CompositePathMacroFilter((PathMacroFilter[])PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensions());
                }
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name2, PathMacrosCollector.getMacroNames(element, filter, PathMacros.getInstance()));
            }
            element.removeAttribute(NAME);
        }
        TreeMap<String, Element> treeMap = map2;
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil", "load"));
        }
        return treeMap;
    }

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil", "getComponentNameIfValid"));
        }
        String name2 = element.getAttributeValue(NAME);
        if (StringUtil.isEmpty((String)name2)) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement((Element)element));
            return null;
        }
        return name2;
    }

    @Nullable
    public static String findComponentName(@NotNull Element element) {
        Parent parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil", "findComponentName"));
        }
        Element componentElement = element;
        while ((parent = componentElement.getParent()) != null && parent instanceof Element) {
            componentElement = (Element)parent;
        }
        return StringUtil.nullize((String)componentElement.getAttributeValue(NAME));
    }
}

