/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.containers.HashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelComboBoxAction<T>
extends ComboBoxAction
implements DumbAware {
    @NotNull
    private final Map<T, AnAction> myActions;
    @NotNull
    private final T[] myActionOrder;

    protected DiffPanelComboBoxAction(@NotNull T[] actionOrder) {
        if (actionOrder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionOrder", "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction", "<init>"));
        }
        this.myActions = new HashMap();
        this.myActionOrder = actionOrder;
    }

    @NotNull
    protected abstract String getActionName();

    @NotNull
    protected abstract T getCurrentOption(@NotNull DiffPanelEx var1);

    @Nullable
    private static DiffPanelEx getDiffPanel(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction", "getDiffPanel"));
        }
        return DiffPanelImpl.fromDataContext(context);
    }

    protected void addAction(T key2, @NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction", "addAction"));
        }
        this.myActions.put(key2, action);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel2 = new JPanel(new BorderLayout());
        JLabel label = new JLabel(this.getActionName());
        label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        panel2.add((Component)label, "West");
        panel2.add((Component)super.createCustomComponent(presentation), "Center");
        return panel2;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (T option : this.myActionOrder) {
            actionGroup.add(this.myActions.get(option));
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        DiffPanelEx diffPanel = DiffPanelComboBoxAction.getDiffPanel(e.getDataContext());
        if (diffPanel != null && diffPanel.getComponent().isDisplayable()) {
            AnAction action = this.myActions.get(this.getCurrentOption(diffPanel));
            Presentation templatePresentation = action.getTemplatePresentation();
            presentation.setIcon(templatePresentation.getIcon());
            presentation.setText(templatePresentation.getText());
            presentation.setEnabled(true);
        } else {
            presentation.setIcon(null);
            presentation.setText(DiffBundle.message((String)"diff.panel.combo.box.action.not.available.action.name", (Object[])new Object[0]));
            presentation.setEnabled(false);
        }
    }

    protected static abstract class DiffPanelAction
    extends DumbAwareAction {
        public DiffPanelAction(@NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/actions/DiffPanelComboBoxAction$DiffPanelAction", "<init>"));
            }
            super(text2);
        }

        public void actionPerformed(AnActionEvent e) {
            DiffPanelEx diffPanel = DiffPanelComboBoxAction.getDiffPanel(e.getDataContext());
            if (diffPanel != null) {
                this.perform(diffPanel);
            }
        }

        protected abstract void perform(@NotNull DiffPanelEx var1);
    }
}

