/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffErrorElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.SortedList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DTree {
    private static final Comparator<DTree> COMPARATOR = (o1, o2) -> {
        boolean b1 = o1.isContainer();
        boolean b2 = o2.isContainer();
        return b1 && b2 || !b1 && !b2 ? o1.getName().compareToIgnoreCase(o2.getName()) : (b1 ? 1 : -1);
    };
    private boolean myExpanded;
    @Nullable
    private final DTree myParent;
    private HashMap<String, DTree> myChildren;
    private String myName;
    private final boolean isContainer;
    private SortedList<DTree> myChildrenList;
    private DiffElement<?> mySource;
    private DiffElement<?> myTarget;
    private DiffType myType;
    private boolean myVisible;
    private String mySeparator;
    private String myPath;

    public DTree(@Nullable DTree parent, @NotNull String name2, boolean container) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/diff/impl/dir/DTree", "<init>"));
        }
        this.myExpanded = true;
        this.myVisible = true;
        this.mySeparator = null;
        this.myPath = null;
        this.myParent = parent;
        this.myName = name2;
        this.isContainer = container;
    }

    @NotNull
    public Collection<DTree> getChildren() {
        this.init();
        if (this.myChildrenList == null) {
            this.myChildrenList = new SortedList(COMPARATOR);
            this.myChildrenList.addAll(this.myChildren.values());
        }
        SortedList<DTree> sortedList = this.myChildrenList;
        if (sortedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/DTree", "getChildren"));
        }
        return sortedList;
    }

    public DTree addChild(@NotNull DiffElement element, boolean source) {
        DTree node;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/diff/impl/dir/DTree", "addChild"));
        }
        this.init();
        this.myChildrenList = null;
        String name2 = element.getName();
        if (this.myChildren.containsKey((Object)name2)) {
            node = (DTree)this.myChildren.get((Object)name2);
        } else {
            node = new DTree(this, name2, element.isContainer());
            this.myChildren.put((Object)name2, (Object)node);
        }
        if (source) {
            node.setSource(element);
        } else {
            node.setTarget(element);
        }
        return node;
    }

    public DiffElement<?> getSource() {
        return this.mySource;
    }

    public void setSource(DiffElement<?> source) {
        this.mySource = source;
    }

    public DiffElement<?> getTarget() {
        return this.myTarget;
    }

    public void setTarget(DiffElement<?> target2) {
        this.myTarget = target2;
    }

    private void init() {
        if (this.myChildren == null) {
            this.myChildren = new HashMap();
        }
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public DTree getParent() {
        return this.myParent;
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.myExpanded = expanded;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public String toString() {
        return this.myName;
    }

    public void update(DirDiffSettings settings) {
        for (DTree tree : this.getChildren()) {
            DiffElement<?> src = tree.getSource();
            DiffElement<?> trg = tree.getTarget();
            if (src instanceof DiffErrorElement || trg instanceof DiffErrorElement) {
                tree.setType(DiffType.ERROR);
            } else if (src == null && trg != null) {
                tree.setType(DiffType.TARGET);
            } else if (src != null && trg == null) {
                tree.setType(DiffType.SOURCE);
            } else {
                DiffType dtype;
                assert (src != null);
                DiffType diffType = dtype = src.getSize() == trg.getSize() ? DiffType.EQUAL : DiffType.CHANGED;
                if (dtype == DiffType.EQUAL) {
                    switch (settings.compareMode) {
                        case CONTENT: {
                            dtype = DTree.isEqual(src, trg) ? DiffType.EQUAL : DiffType.CHANGED;
                            break;
                        }
                        case TIMESTAMP: {
                            dtype = (double)Math.abs(src.getTimeStamp() - trg.getTimeStamp()) <= settings.compareTimestampAccuracy ? DiffType.EQUAL : DiffType.CHANGED;
                        }
                    }
                }
                tree.setType(dtype);
            }
            tree.update(settings);
        }
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void updateVisibility(DirDiffSettings settings) {
        if (this.getChildren().isEmpty()) {
            if (this.myType == DiffType.ERROR) {
                this.myVisible = true;
                return;
            }
            if (this.myType != DiffType.SEPARATOR && !"".equals(settings.getFilter()) && !settings.getFilterPattern().matcher(this.getName()).matches()) {
                this.myVisible = false;
                return;
            }
            if (this.myType == null) {
                this.myVisible = true;
            } else {
                switch (this.myType) {
                    case SOURCE: {
                        this.myVisible = settings.showNewOnSource;
                        break;
                    }
                    case TARGET: {
                        this.myVisible = settings.showNewOnTarget;
                        break;
                    }
                    case SEPARATOR: 
                    case ERROR: {
                        this.myVisible = true;
                        break;
                    }
                    case CHANGED: {
                        this.myVisible = settings.showDifferent;
                        break;
                    }
                    case EQUAL: {
                        this.myVisible = settings.showEqual;
                    }
                }
            }
        } else {
            this.myVisible = false;
            for (DTree child : this.myChildren.values()) {
                child.updateVisibility(settings);
                this.myVisible = this.myVisible || child.isVisible();
            }
        }
    }

    public void reset() {
        this.myChildren.clear();
    }

    public void remove(DTree node) {
        this.init();
        boolean removed = this.myChildrenList.remove((Object)node);
        if (removed) {
            for (String key2 : this.myChildren.keySet()) {
                if (this.myChildren.get((Object)key2) != node) continue;
                this.myChildren.remove((Object)key2);
                return;
            }
        }
    }

    private static boolean isEqual(DiffElement file1, DiffElement file2) {
        if (file1.isContainer() || file2.isContainer()) {
            return false;
        }
        if (file1.getSize() != file2.getSize()) {
            return false;
        }
        try {
            return Arrays.equals(file1.getContent(), file2.getContent());
        }
        catch (IOException e) {
            return false;
        }
    }

    public DiffType getType() {
        return this.myType;
    }

    public void setType(DiffType type2) {
        this.myType = type2;
    }

    public String getPath() {
        if (this.myPath == null) {
            DTree parent = this.getParent();
            this.myPath = parent != null ? parent.getPath() + this.getName() + (this.isContainer ? this.getSeparator() : "") : this.getName() + (this.isContainer ? this.getSeparator() : "");
        }
        return this.myPath;
    }

    private String getSeparator() {
        if (this.mySeparator == null) {
            this.mySeparator = this.mySource != null ? this.mySource.getSeparator() : (this.myTarget != null ? this.myTarget.getSeparator() : "");
        }
        return this.mySeparator;
    }
}

