/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DiffPreviewProvider {
    public static final ExtensionPointName<DiffPreviewProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.diffPreviewProvider");
    @NonNls
    private static final String LEFT_TEXT = "class MyClass {\n  int value;\n\n  void leftOnly() {}\n\n  void foo() {\n   // Left changes\n  }\n\n  void bar() {\n\n  }\n}";
    @NonNls
    private static final String CENTER_TEXT = "class MyClass {\n  int value;\n\n  void foo() {\n  }\n\n  void removedFromLeft() {}\n\n  void bar() {\n\n  }\n}";
    @NonNls
    private static final String RIGHT_TEXT = "class MyClass {\n  long value;\n\n  void foo() {\n   // Right changes\n  }\n\n  void removedFromLeft() {}\n\n  void bar() {\n  }\n\n}";

    @NotNull
    public abstract DiffContent[] createContents();

    @NotNull
    public static DiffContent[] getContents() {
        DiffPreviewProvider[] providers2 = (DiffPreviewProvider[])Extensions.getExtensions(EP_NAME);
        if (providers2.length != 0) {
            DiffContent[] diffContentArray = providers2[0].createContents();
            if (diffContentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "getContents"));
            }
            return diffContentArray;
        }
        DiffContent[] diffContentArray = DiffPreviewProvider.createContent(LEFT_TEXT, CENTER_TEXT, RIGHT_TEXT, (FileType)StdFileTypes.JAVA);
        if (diffContentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "getContents"));
        }
        return diffContentArray;
    }

    @NotNull
    public static DiffContent[] createContent(@NotNull String left, @NotNull String center, @NotNull String right, @NotNull FileType fileType) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        if (center == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "center", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        DiffContent[] diffContentArray = new DiffContent[]{DiffPreviewProvider.createContent(left, fileType), DiffPreviewProvider.createContent(center, fileType), DiffPreviewProvider.createContent(right, fileType)};
        if (diffContentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        return diffContentArray;
    }

    @NotNull
    private static DiffContent createContent(@NotNull String text2, @NotNull FileType fileType) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(text2, fileType);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/settings/DiffPreviewProvider", "createContent"));
        }
        return documentContent;
    }
}

