/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ThreePanels
extends JPanel {
    private final JComponent[] myDividers;
    private final JComponent[] myPanels;

    public ThreePanels(JComponent[] panels, JComponent[] dividers) {
        this.myDividers = dividers;
        this.myPanels = panels;
        this.addAll(dividers);
        this.addAll(panels);
    }

    private void addAll(JComponent[] components) {
        for (JComponent component : components) {
            this.add((Component)component, -1);
        }
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        int dividersTotalWidth = 0;
        for (JComponent divider : this.myDividers) {
            dividersTotalWidth += divider.getPreferredSize().width;
        }
        int panelWidth = (width - dividersTotalWidth) / 3;
        int x = 0;
        for (int i2 = 0; i2 < this.myPanels.length; ++i2) {
            JComponent panel2 = this.myPanels[i2];
            panel2.setBounds(x, 0, panelWidth, height);
            panel2.validate();
            x += panelWidth;
            if (i2 >= this.myDividers.length) continue;
            JComponent divider = this.myDividers[i2];
            int dividerWidth = divider.getPreferredSize().width;
            divider.setBounds(x, 0, dividerWidth, height);
            divider.validate();
            x += dividerWidth;
        }
    }
}

