/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;

public class DeleteLineAction
extends TextComponentEditorAction {
    public DeleteLineAction() {
        super((EditorActionHandler)new Handler());
    }

    private static TextRange getRangeToDelete(Editor editor, Caret caret) {
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        int startOffset = EditorUtil.getNotFoldedLineStartOffset(editor, selectionStart);
        int endOffset = EditorUtil.getNotFoldedLineEndOffset(editor, selectionEnd > 0 && selectionEnd != selectionStart ? selectionEnd - 1 : selectionEnd);
        if (endOffset < editor.getDocument().getTextLength()) {
            ++endOffset;
        } else if (startOffset > 0) {
            --startOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editor.delete.line");
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            CopyPasteManager.getInstance().stopKillRings();
            Document document = editor.getDocument();
            List carets = caret == null ? editor.getCaretModel().getAllCarets() : Collections.singletonList(caret);
            editor.getCaretModel().runBatchCaretOperation(() -> {
                int[] caretColumns = new int[carets.size()];
                int caretIndex = carets.size() - 1;
                TextRange range = DeleteLineAction.getRangeToDelete(editor, (Caret)carets.get(caretIndex));
                while (caretIndex >= 0) {
                    int currentCaretIndex = caretIndex;
                    TextRange currentRange = range;
                    while (--caretIndex >= 0 && (range = DeleteLineAction.getRangeToDelete(editor, (Caret)carets.get(caretIndex))).getEndOffset() >= currentRange.getStartOffset()) {
                        currentRange = new TextRange(range.getStartOffset(), currentRange.getEndOffset());
                    }
                    for (int i2 = caretIndex + 1; i2 <= currentCaretIndex; ++i2) {
                        caretColumns[i2] = ((Caret)carets.get((int)i2)).getVisualPosition().column;
                    }
                    int targetLine = editor.offsetToVisualPosition((int)currentRange.getStartOffset()).line;
                    document.deleteString(currentRange.getStartOffset(), currentRange.getEndOffset());
                    for (int i3 = caretIndex + 1; i3 <= currentCaretIndex; ++i3) {
                        ((Caret)carets.get(i3)).moveToVisualPosition(new VisualPosition(targetLine, caretColumns[i3]));
                    }
                }
            });
        }
    }
}

