/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;

public class KillToWordStartAction
extends TextComponentEditorAction {
    public KillToWordStartAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            CaretModel caretModel = editor.getCaretModel();
            int caretOffset = caretModel.getOffset();
            if (caretOffset <= 0) {
                return;
            }
            boolean camel = editor.getSettings().isCamelWords();
            for (int i2 = caretOffset - 1; i2 >= 0; --i2) {
                if (!EditorActionUtil.isWordOrLexemeStart(editor, i2, camel)) continue;
                KillRingUtil.cut(editor, i2, caretOffset);
                return;
            }
            KillRingUtil.cut(editor, 0, caretOffset);
        }
    }
}

