/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import org.jetbrains.annotations.NotNull;

public class ToggleUseSoftWrapsInPreviewAction
extends ToggleAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/ToggleUseSoftWrapsInPreviewAction", "update"));
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null || editor.getEditorKind() != EditorKind.PREVIEW) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e);
    }

    public boolean isSelected(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        return editor != null && editor.getSettings().isUseSoftWraps();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor, SoftWrapAppliancePlaces.PREVIEW, state);
        }
    }
}

