/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontPreferencesImpl
extends ModifiableFontPreferences {
    @NotNull
    private final TObjectIntHashMap<String> myFontSizes = new TObjectIntHashMap();
    @NotNull
    private final List<String> myEffectiveFontFamilies = ContainerUtilRt.newArrayList();
    @NotNull
    private final List<String> myRealFontFamilies = ContainerUtilRt.newArrayList();
    private boolean myUseLigatures;
    private float myLineSpacing = 1.0f;
    @Nullable
    private Runnable myChangeListener;
    private int myTemplateFontSize = DEFAULT_FONT_SIZE;

    public void setChangeListener(@Nullable Runnable changeListener) {
        this.myChangeListener = changeListener;
    }

    @Nullable
    public Runnable getChangeListener() {
        return this.myChangeListener;
    }

    public void clear() {
        this.myFontSizes.clear();
        this.clearFonts();
    }

    public void clearFonts() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        this.myUseLigatures = false;
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontName", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "hasSize"));
        }
        return this.myFontSizes.containsKey((Object)fontName);
    }

    public float getLineSpacing() {
        return this.myLineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
    }

    public int getSize(@NotNull String fontFamily) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getSize"));
        }
        int result2 = this.myFontSizes.get((Object)fontFamily);
        if (result2 <= 0) {
            result2 = this.myTemplateFontSize;
        }
        return result2 > 0 ? result2 : DEFAULT_FONT_SIZE;
    }

    public void setSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setSize"));
        }
        this.myFontSizes.put((Object)fontFamily, size);
        this.myTemplateFontSize = size;
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @NotNull
    public List<String> getEffectiveFontFamilies() {
        List<String> list2 = this.myEffectiveFontFamilies;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getEffectiveFontFamilies"));
        }
        return list2;
    }

    @NotNull
    public List<String> getRealFontFamilies() {
        List<String> list2 = this.myRealFontFamilies;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getRealFontFamilies"));
        }
        return list2;
    }

    public void register(@NotNull String fontFamily, int size) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "register"));
        }
        String fallbackFontFamily = FontPreferences.getFallbackName((String)fontFamily, (int)size, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        this.setSize(fontFamily, size);
    }

    @NotNull
    public String getFontFamily() {
        String string = this.myEffectiveFontFamilies.isEmpty() ? DEFAULT_FONT_NAME : this.myEffectiveFontFamilies.get(0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getFontFamily"));
        }
        return string;
    }

    public void addFontFamily(@NotNull String fontFamily) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "addFontFamily"));
        }
        String fallbackFontFamily = FontPreferences.getFallbackName((String)fontFamily, (int)DEFAULT_FONT_SIZE, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "copyTo"));
        }
        if (preferences instanceof ModifiableFontPreferences) {
            ModifiableFontPreferences modifiablePreferences = (ModifiableFontPreferences)preferences;
            modifiablePreferences.setEffectiveFontFamilies(this.myEffectiveFontFamilies);
            modifiablePreferences.setRealFontFamilies(this.myRealFontFamilies);
            modifiablePreferences.setTemplateFontSize(this.myTemplateFontSize);
            modifiablePreferences.resetFontSizes();
            for (String fontFamily : this.myRealFontFamilies) {
                if (!this.myFontSizes.containsKey((Object)fontFamily)) continue;
                modifiablePreferences.setFontSize(fontFamily, this.myFontSizes.get((Object)fontFamily));
            }
            modifiablePreferences.setUseLigatures(this.myUseLigatures);
            modifiablePreferences.setLineSpacing(this.myLineSpacing);
        }
    }

    public void resetFontSizes() {
        this.myFontSizes.clear();
    }

    public void setFontSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setFontSize"));
        }
        this.myFontSizes.put((Object)fontFamily, size);
    }

    public void setTemplateFontSize(int size) {
        this.myTemplateFontSize = size;
    }

    public void setEffectiveFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamilies", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setEffectiveFontFamilies"));
        }
        this.myEffectiveFontFamilies.clear();
        this.myEffectiveFontFamilies.addAll(fontFamilies);
    }

    public void setRealFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamilies", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setRealFontFamilies"));
        }
        this.myRealFontFamilies.clear();
        this.myRealFontFamilies.addAll(fontFamilies);
    }

    public int hashCode() {
        return this.myRealFontFamilies.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FontPreferencesImpl that = (FontPreferencesImpl)((Object)o);
        if (!this.myRealFontFamilies.equals(that.myRealFontFamilies)) {
            return false;
        }
        for (String fontFamily : this.myRealFontFamilies) {
            if (this.myFontSizes.get((Object)fontFamily) == that.myFontSizes.get((Object)fontFamily)) continue;
            return false;
        }
        if (this.myUseLigatures != that.myUseLigatures) {
            return false;
        }
        return this.myLineSpacing == that.myLineSpacing;
    }

    public boolean useLigatures() {
        return this.myUseLigatures;
    }

    public void setUseLigatures(boolean useLigatures) {
        if (useLigatures != this.myUseLigatures) {
            this.myUseLigatures = useLigatures;
            if (this.myChangeListener != null) {
                this.myChangeListener.run();
            }
        }
    }

    public String toString() {
        return "Effective font families: " + this.myEffectiveFontFamilies;
    }
}

