/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.util.containers.PeekableIterator;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public interface MarkupIterator<T>
extends PeekableIterator<T> {
    public static final MarkupIterator EMPTY = new MarkupIterator(){

        @Override
        public void dispose() {
        }

        public Object peek() {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new NoSuchElementException();
        }
    };

    public void dispose();

    @NotNull
    public static <T> MarkupIterator<T> mergeIterators(final @NotNull MarkupIterator<T> iterator1, final @NotNull MarkupIterator<T> iterator2, final @NotNull Comparator<? super T> comparator2) {
        if (iterator1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator1", "com/intellij/openapi/editor/ex/MarkupIterator", "mergeIterators"));
        }
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator2", "com/intellij/openapi/editor/ex/MarkupIterator", "mergeIterators"));
        }
        if (comparator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/openapi/editor/ex/MarkupIterator", "mergeIterators"));
        }
        MarkupIterator markupIterator = new MarkupIterator<T>(){

            @Override
            public void dispose() {
                iterator1.dispose();
                iterator2.dispose();
            }

            public boolean hasNext() {
                return iterator1.hasNext() || iterator2.hasNext();
            }

            public T next() {
                return this.choose().next();
            }

            @NotNull
            private MarkupIterator<T> choose() {
                Object t2;
                Object t1 = iterator1.hasNext() ? iterator1.peek() : null;
                Object object = t2 = iterator2.hasNext() ? iterator2.peek() : null;
                if (t1 == null) {
                    MarkupIterator markupIterator = iterator2;
                    if (markupIterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/MarkupIterator$2", "choose"));
                    }
                    return markupIterator;
                }
                if (t2 == null) {
                    MarkupIterator markupIterator = iterator1;
                    if (markupIterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/MarkupIterator$2", "choose"));
                    }
                    return markupIterator;
                }
                int compare = comparator2.compare(t1, t2);
                MarkupIterator markupIterator = compare < 0 ? iterator1 : iterator2;
                if (markupIterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/MarkupIterator$2", "choose"));
                }
                return markupIterator;
            }

            public void remove() {
                throw new NoSuchElementException();
            }

            public T peek() {
                return this.choose().peek();
            }
        };
        if (markupIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/MarkupIterator", "mergeIterators"));
        }
        return markupIterator;
    }
}

