/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FoldRegionImpl
extends RangeMarkerImpl
implements FoldRegion {
    private boolean myIsExpanded;
    private final EditorImpl myEditor;
    private final String myPlaceholderText;
    private final FoldingGroup myGroup;
    private final boolean myShouldNeverExpand;
    private boolean myDocumentRegionWasChanged;

    FoldRegionImpl(@NotNull EditorImpl editor, int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group, boolean shouldNeverExpand) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/FoldRegionImpl", "<init>"));
        }
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/openapi/editor/impl/FoldRegionImpl", "<init>"));
        }
        super(editor.getDocument(), startOffset, endOffset, false);
        this.myGroup = group;
        this.myShouldNeverExpand = shouldNeverExpand;
        this.myIsExpanded = true;
        this.myEditor = editor;
        this.myPlaceholderText = placeholder;
    }

    public boolean isExpanded() {
        return this.myIsExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, true);
    }

    void setExpanded(boolean expanded, boolean notify) {
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (this.myGroup == null) {
            FoldRegionImpl.doSetExpanded(expanded, foldingModel, this, notify);
        } else {
            for (FoldRegion region : foldingModel.getGroupedRegions(this.myGroup)) {
                FoldRegionImpl.doSetExpanded(expanded, foldingModel, region, notify || region != this);
                if (region.isExpanded() == expanded) continue;
                for (FoldRegion regionToRevert : foldingModel.getGroupedRegions(this.myGroup)) {
                    if (regionToRevert == region) break;
                    FoldRegionImpl.doSetExpanded(!expanded, foldingModel, regionToRevert, notify || region != this);
                }
                return;
            }
        }
    }

    private static void doSetExpanded(boolean expanded, FoldingModelImpl foldingModel, FoldRegion region, boolean notify) {
        if (expanded) {
            foldingModel.expandFoldRegion(region, notify);
        } else {
            foldingModel.collapseFoldRegion(region, notify);
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.intervalStart() < this.intervalEnd();
    }

    void setExpandedInternal(boolean toExpand) {
        this.myIsExpanded = toExpand;
    }

    @NotNull
    public String getPlaceholderText() {
        String string = this.myPlaceholderText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldRegionImpl", "getPlaceholderText"));
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public FoldingGroup getGroup() {
        return this.myGroup;
    }

    public boolean shouldNeverExpand() {
        return this.myShouldNeverExpand;
    }

    boolean hasDocumentRegionChanged() {
        return this.myDocumentRegionWasChanged;
    }

    void resetDocumentRegionChanged() {
        this.myDocumentRegionWasChanged = false;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/FoldRegionImpl", "changedUpdateImpl"));
        }
        if (this.isValid()) {
            int oldStart = this.intervalStart();
            int oldEnd = this.intervalEnd();
            int changeStart = e.getOffset();
            int changeEnd = e.getOffset() + e.getOldLength();
            if (changeStart < oldEnd && changeEnd > oldStart) {
                this.myDocumentRegionWasChanged = true;
            }
        }
        super.changedUpdateImpl(e);
        if (this.isValid()) {
            this.alignToSurrogateBoundaries();
        }
    }

    @Override
    protected void onReTarget(int startOffset, int endOffset, int destOffset) {
        this.alignToSurrogateBoundaries();
    }

    private void alignToSurrogateBoundaries() {
        DocumentEx document = this.getDocument();
        int start = this.intervalStart();
        int end = this.intervalEnd();
        if (DocumentUtil.isInsideSurrogatePair(document, start)) {
            this.setIntervalStart(start - 1);
        }
        if (DocumentUtil.isInsideSurrogatePair(document, end)) {
            this.setIntervalEnd(end - 1);
        }
    }

    @Override
    public void dispose() {
        this.myEditor.getFoldingModel().removeRegionFromTree(this);
    }

    @Override
    public String toString() {
        return "FoldRegion " + (this.myIsExpanded ? "-" : "+") + "(" + this.getStartOffset() + ":" + this.getEndOffset() + ")" + (this.isValid() ? "" : "(invalid)") + ", placeholder='" + this.myPlaceholderText + "'";
    }
}

