/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.text.CharArrayIterator;
import com.intellij.util.text.CharSequenceIterator;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFallbackIterator {
    private static final char COMPLEX_CHAR_START = '\u0300';
    private final BreakAtEveryCharacterIterator myTrivialBreaker = new BreakAtEveryCharacterIterator();
    private FontPreferences myFontPreferences = new FontPreferencesImpl();
    private int myFontStyle = 0;
    private FontRenderContext myFontRenderContext;
    private char[] myTextAsArray;
    private CharSequence myTextAsCharSequence;
    private BreakIterator myIterator;
    private int myStart;
    private int myEnd;
    private FontInfo myFontInfo;
    private FontInfo myNextFontInfo;

    public FontFallbackIterator setPreferredFonts(@NotNull FontPreferences fontPreferences) {
        if (fontPreferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontPreferences", "com/intellij/openapi/editor/impl/FontFallbackIterator", "setPreferredFonts"));
        }
        this.myFontPreferences = fontPreferences;
        return this;
    }

    public FontFallbackIterator setFontStyle(@JdkConstants.FontStyle int fontStyle) {
        this.myFontStyle = fontStyle;
        return this;
    }

    public FontFallbackIterator setFontRenderContext(@Nullable FontRenderContext fontRenderContext) {
        this.myFontRenderContext = fontRenderContext;
        return this;
    }

    public void start(@NotNull CharSequence text2, int start, int end) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/FontFallbackIterator", "start"));
        }
        assert (0 <= start && start <= end && end <= text2.length()) : "Text length: " + text2.length() + ", start: " + start + ", end: " + end;
        CharSequenceIterator characterIterator = null;
        for (int i2 = start; i2 < end; ++i2) {
            if (text2.charAt(i2) < '\u0300') continue;
            characterIterator = new CharSequenceIterator(text2, start, end);
            break;
        }
        this.doStart(text2, null, (CharacterIterator)characterIterator, start, end);
    }

    public void start(@NotNull char[] text2, int start, int end) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/FontFallbackIterator", "start"));
        }
        assert (0 <= start && start <= end && end <= text2.length) : "Text length: " + text2.length + ", start: " + start + ", end: " + end;
        CharArrayIterator characterIterator = null;
        for (int i2 = start; i2 < end; ++i2) {
            if (text2[i2] < '\u0300') continue;
            characterIterator = new CharArrayIterator(text2, start, end);
            break;
        }
        this.doStart(null, text2, (CharacterIterator)characterIterator, start, end);
    }

    private void doStart(CharSequence textAsCharSequence, char[] textAsArray, CharacterIterator characterIterator, int start, int end) {
        this.myTextAsCharSequence = textAsCharSequence;
        this.myTextAsArray = textAsArray;
        if (characterIterator == null) {
            this.myTrivialBreaker.setRange(start, end);
            this.myIterator = this.myTrivialBreaker;
        } else {
            this.myIterator = BreakIterator.getCharacterInstance();
            this.myIterator.setText(characterIterator);
        }
        this.myStart = this.myEnd = this.myIterator.first();
        assert (this.myStart == start);
        this.myNextFontInfo = null;
        this.myFontInfo = null;
        this.advance();
    }

    public boolean atEnd() {
        return this.myStart == this.myEnd;
    }

    public void advance() {
        int end;
        this.myStart = this.myEnd;
        this.myEnd = this.myIterator.current();
        this.myFontInfo = this.myNextFontInfo;
        while ((end = this.myIterator.next()) != -1) {
            this.myNextFontInfo = this.getFontAbleToDisplay(this.myEnd, end);
            if (this.myFontInfo == null) {
                this.myFontInfo = this.myNextFontInfo;
            }
            if (this.myNextFontInfo.equals(this.myFontInfo)) {
                this.myEnd = end;
                continue;
            }
            return;
        }
    }

    private FontInfo getFontAbleToDisplay(int start, int end) {
        if (this.myTextAsCharSequence == null) {
            return ComplementaryFontsRegistry.getFontAbleToDisplay(this.myTextAsArray, start, end, this.myFontStyle, this.myFontPreferences, this.myFontRenderContext);
        }
        return ComplementaryFontsRegistry.getFontAbleToDisplay(this.myTextAsCharSequence, start, end, this.myFontStyle, this.myFontPreferences, this.myFontRenderContext);
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @NotNull
    public FontInfo getFontInfo() {
        if (this.myFontRenderContext == null) {
            throw new IllegalStateException("FontRenderContext must be set to generate FontInfo");
        }
        FontInfo fontInfo = this.myFontInfo;
        if (fontInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontFallbackIterator", "getFontInfo"));
        }
        return fontInfo;
    }

    @NotNull
    public Font getFont() {
        Font font = this.myFontInfo.getFont();
        if (font == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FontFallbackIterator", "getFont"));
        }
        return font;
    }

    private static class BreakAtEveryCharacterIterator
    extends BreakIterator {
        private int myStart;
        private int myEnd;
        private int myCurrent;

        private BreakAtEveryCharacterIterator() {
        }

        public void setRange(int start, int end) {
            this.myStart = start;
            this.myEnd = end;
        }

        @Override
        public int first() {
            this.myCurrent = this.myStart;
            return this.myCurrent;
        }

        @Override
        public int last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int next(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int next() {
            return this.myCurrent >= this.myEnd ? -1 : (this.myCurrent = this.myCurrent + 1);
        }

        @Override
        public int previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int following(int offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int current() {
            return this.myCurrent;
        }

        @Override
        public CharacterIterator getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setText(CharacterIterator newText) {
            throw new UnsupportedOperationException();
        }
    }
}

