/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenDocument
implements DocumentEx {
    private final ImmutableCharSequence myText;
    @Nullable
    private volatile LineSet myLineSet;
    private final long myStamp;
    private volatile SoftReference<String> myTextString;

    /*
     * WARNING - void declaration
     */
    FrozenDocument(@NotNull ImmutableCharSequence text2, @Nullable LineSet lineSet, long stamp, @Nullable String string) {
        void textString;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/FrozenDocument", "<init>"));
        }
        this.myText = text2;
        this.myLineSet = lineSet;
        this.myStamp = stamp;
        this.myTextString = textString == null ? null : new SoftReference((Object)textString);
    }

    @NotNull
    private LineSet getLineSet() {
        LineSet lineSet = this.myLineSet;
        if (lineSet == null) {
            this.myLineSet = lineSet = LineSet.createLineSet((CharSequence)this.myText);
        }
        LineSet lineSet2 = lineSet;
        if (lineSet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getLineSet"));
        }
        return lineSet2;
    }

    public FrozenDocument applyEvent(DocumentEvent event, int newStamp) {
        int offset = event.getOffset();
        int oldEnd = offset + event.getOldLength();
        ImmutableCharSequence newText = this.myText.delete(offset, oldEnd).insert(offset, event.getNewFragment());
        LineSet newLineSet = this.getLineSet().update((CharSequence)this.myText, offset, oldEnd, event.getNewFragment(), event.isWholeTextReplaced());
        return new FrozenDocument(newText, newLineSet, newStamp, null);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.getLineSet().createIterator();
        if (lineIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "createLineIterator"));
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/FrozenDocument", "replaceText"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearLineModificationFlags() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/FrozenDocument", "removeRangeMarker"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/FrozenDocument", "registerRangeMarker"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/FrozenDocument", "processRangeMarkers"));
        }
        return true;
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/FrozenDocument", "processRangeMarkersOverlappingWith"));
        }
        return true;
    }

    @NotNull
    public String getText() {
        String s = (String)SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference((Object)s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getText"));
        }
        return string;
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/FrozenDocument", "getText"));
        }
        String string = this.myText.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getText"));
        }
        return string;
    }

    @NotNull
    public CharSequence getCharsSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getCharsSequence"));
        }
        return immutableCharSequence;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getImmutableCharSequence"));
        }
        return immutableCharSequence;
    }

    public int getLineCount() {
        return this.getLineSet().getLineCount();
    }

    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/FrozenDocument", "insertString"));
        }
        throw new UnsupportedOperationException();
    }

    public void deleteString(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/FrozenDocument", "replaceString"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return this.myStamp;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/openapi/editor/impl/FrozenDocument", "removeGuardedBlock"));
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RangeMarker getOffsetGuard(int offset) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RangeMarker getRangeGuard(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public void startGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    public void stopGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/FrozenDocument", "setText"));
        }
        throw new UnsupportedOperationException();
    }

    public int getLineSeparatorLength(int line) {
        return this.getLineSet().getSeparatorLength(line);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FrozenDocument", "getUserData"));
        }
        throw new UnsupportedOperationException();
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FrozenDocument", "putUserData"));
        }
        throw new UnsupportedOperationException();
    }
}

