/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.impl.event.RetargetRangeMarkers;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualRangeMarker
implements Segment {
    private final int myStart;
    private final int myEnd;
    private final boolean myGreedyLeft;
    private final boolean myGreedyRight;
    private final boolean mySurviveOnExternalChange;
    private final PersistentRangeMarker.LinesCols myLinesCols;

    public ManualRangeMarker(int start, int end, boolean greedyLeft, boolean greedyRight, boolean surviveOnExternalChange, @Nullable PersistentRangeMarker.LinesCols linesCols) {
        this.myStart = start;
        this.myEnd = end;
        this.myGreedyLeft = greedyLeft;
        this.myGreedyRight = greedyRight;
        this.mySurviveOnExternalChange = surviveOnExternalChange;
        this.myLinesCols = linesCols;
    }

    @Nullable
    public ManualRangeMarker getUpdatedRange(@NotNull DocumentEvent event, @NotNull FrozenDocument documentBefore) {
        TextRange range;
        int start;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/ManualRangeMarker", "getUpdatedRange"));
        }
        if (documentBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentBefore", "com/intellij/openapi/editor/impl/ManualRangeMarker", "getUpdatedRange"));
        }
        if (event instanceof RetargetRangeMarkers && this.myStart >= (start = ((RetargetRangeMarkers)event).getStartOffset()) && this.myEnd <= ((RetargetRangeMarkers)event).getEndOffset()) {
            int delta = ((RetargetRangeMarkers)event).getMoveDestinationOffset() - start;
            return new ManualRangeMarker(this.myStart + delta, this.myEnd + delta, this.myGreedyLeft, this.myGreedyRight, this.mySurviveOnExternalChange, null);
        }
        if (this.mySurviveOnExternalChange && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.myStart, this.myEnd)) {
            Pair<TextRange, PersistentRangeMarker.LinesCols> pair2;
            PersistentRangeMarker.LinesCols linesCols = this.myLinesCols != null ? this.myLinesCols : PersistentRangeMarker.storeLinesAndCols(documentBefore, this.myStart, this.myEnd);
            Pair<TextRange, PersistentRangeMarker.LinesCols> pair3 = pair2 = linesCols == null ? null : PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, linesCols);
            if (pair2 != null) {
                return new ManualRangeMarker(((TextRange)pair2.first).getStartOffset(), ((TextRange)pair2.first).getEndOffset(), this.myGreedyLeft, this.myGreedyRight, true, (PersistentRangeMarker.LinesCols)pair2.second);
            }
        }
        return (range = RangeMarkerImpl.applyChange(event, this.myStart, this.myEnd, this.myGreedyLeft, this.myGreedyRight)) == null ? null : new ManualRangeMarker(range.getStartOffset(), range.getEndOffset(), this.myGreedyLeft, this.myGreedyRight, this.mySurviveOnExternalChange, null);
    }

    public int getStartOffset() {
        return this.myStart;
    }

    public int getEndOffset() {
        return this.myEnd;
    }

    public String toString() {
        return "ManualRangeMarker" + TextRange.create((Segment)this);
    }
}

