/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentCaret;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentCaretModel
implements CaretModel {
    private final JTextComponent myTextComponent;
    private final TextComponentEditor myEditor;
    private final Caret myCaret;

    public TextComponentCaretModel(@NotNull JTextComponent textComponent, @NotNull TextComponentEditor editor) {
        if (textComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textComponent", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "<init>"));
        }
        this.myTextComponent = textComponent;
        this.myEditor = editor;
        this.myCaret = new TextComponentCaret((Editor)editor);
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "moveToLogicalPosition"));
        }
        this.moveToOffset(this.myEditor.logicalPositionToOffset(pos), false);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "moveToVisualPosition"));
        }
        this.moveToLogicalPosition(this.myEditor.visualToLogicalPosition(pos));
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int currentPosition;
        int targetOffset = Math.min(offset, this.myTextComponent.getText().length());
        if (targetOffset != (currentPosition = this.myTextComponent.getCaretPosition())) {
            if (targetOffset == this.myTextComponent.getCaret().getMark()) {
                this.myTextComponent.setCaretPosition(currentPosition);
                this.myTextComponent.moveCaretPosition(targetOffset);
            } else {
                this.myTextComponent.setCaretPosition(targetOffset);
            }
        }
    }

    public boolean isUpToDate() {
        return true;
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        int lineStart;
        int line;
        int caretPos = this.myTextComponent.getCaretPosition();
        if (this.myTextComponent instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this.myTextComponent;
            try {
                line = textArea.getLineOfOffset(caretPos);
                lineStart = textArea.getLineStartOffset(line);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            line = 0;
            lineStart = 0;
        }
        LogicalPosition logicalPosition = new LogicalPosition(line, caretPos - lineStart);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "getLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition pos = this.getLogicalPosition();
        VisualPosition visualPosition = new VisualPosition(pos.line, pos.column);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "getVisualPosition"));
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.myTextComponent.getCaretPosition();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "addCaretListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "removeCaretListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getVisualLineStart() {
        return 0;
    }

    public int getVisualLineEnd() {
        return 0;
    }

    public TextAttributes getTextAttributes() {
        return null;
    }

    public boolean supportsMultipleCarets() {
        return false;
    }

    @NotNull
    public Caret getCurrentCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "getCurrentCaret"));
        }
        return caret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "getPrimaryCaret"));
        }
        return caret;
    }

    public int getCaretCount() {
        return 1;
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List<Caret> list2 = Collections.singletonList(this.myCaret);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "getAllCarets"));
        }
        return list2;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "getCaretAt"));
        }
        return this.myCaret.getVisualPosition().equals((Object)pos) ? this.myCaret : null;
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "addCaret"));
        }
        return null;
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "addCaret"));
        }
        return null;
    }

    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "removeCaret"));
        }
        return false;
    }

    public void removeSecondaryCarets() {
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        if (caretStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretStates", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "setCaretsAndSelections"));
        }
        throw new UnsupportedOperationException("Multiple carets are not supported");
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates, boolean updateSystemSelection) {
        if (caretStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretStates", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "setCaretsAndSelections"));
        }
        throw new UnsupportedOperationException("Multiple carets are not supported");
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        throw new UnsupportedOperationException("Multiple carets are not supported");
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "runForEachCaret"));
        }
        action.perform(this.myCaret);
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "runForEachCaret"));
        }
        action.perform(this.myCaret);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/editor/textarea/TextComponentCaretModel", "runBatchCaretOperation"));
        }
        runnable2.run();
    }
}

