/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemTreeAction
extends ExternalSystemAction {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && ExternalSystemTreeAction.getTree(e) != null;
    }

    @Nullable
    protected static JTree getTree(AnActionEvent e) {
        return (JTree)ExternalSystemDataKeys.PROJECTS_TREE.getData(e.getDataContext());
    }

    public static class ExpandAll
    extends ExternalSystemTreeAction {
        public void actionPerformed(AnActionEvent e) {
            JTree tree = ExpandAll.getTree(e);
            if (tree == null) {
                return;
            }
            for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
                tree.expandRow(i2);
            }
        }
    }

    public static class CollapseAll
    extends ExternalSystemTreeAction {
        public void actionPerformed(AnActionEvent e) {
            JTree tree = CollapseAll.getTree(e);
            if (tree == null) {
                return;
            }
            for (int row = tree.getRowCount() - 1; row >= 0; --row) {
                tree.collapseRow(row);
            }
        }
    }
}

