/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStorage;
import com.intellij.openapi.externalSystem.configurationStore.PersistentMapManagerKt;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\"\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/FileSystemExternalSystemStorage;", "Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStorage;", "dirName", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "dir", "Ljava/nio/file/Path;", "getDir", "()Ljava/nio/file/Path;", "hasSomeData", "", "isDirty", "()Z", "forceSave", "", "nameToPath", "name", "read", "Lorg/jdom/Element;", "remove", "rename", "oldName", "newName", "write", "element", "filter", "Lcom/intellij/openapi/util/JDOMUtil$ElementOutputFilter;", "external-system-impl"})
public abstract class FileSystemExternalSystemStorage
implements ExternalSystemStorage {
    private final boolean isDirty = false;
    @NotNull
    private final Path dir;
    private boolean hasSomeData;

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @NotNull
    protected final Path getDir() {
        return this.dir;
    }

    @NotNull
    protected Path nameToPath(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Path path = this.dir.resolve(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir.resolve(name)");
        return path;
    }

    @Override
    public void forceSave() {
    }

    @Override
    public void remove(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (!this.hasSomeData) {
            return;
        }
        PathKt.delete((Path)this.nameToPath(name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Element read(@NotNull String name2) {
        Element element;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (!this.hasSomeData) {
            return null;
        }
        InputStream inputStream = PathKt.inputStreamIfExists((Path)this.nameToPath(name2));
        if (inputStream != null) {
            Closeable closeable = inputStream;
            boolean bl = false;
            try {
                InputStream it = (InputStream)closeable;
                Element element2 = JdomKt.loadElement((InputStream)it);
                element = element2;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        element = null;
        return element;
    }

    @Override
    public void write(@NotNull String name2, @NotNull Element element, @Nullable JDOMUtil.ElementOutputFilter filter) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.hasSomeData = true;
        JdomKt.write$default((Parent)((Parent)element), (Path)this.nameToPath(name2), null, (JDOMUtil.ElementOutputFilter)filter, (int)2, null);
    }

    @Override
    public void rename(@NotNull String oldName, @NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)oldName, (String)"oldName");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        if (!this.hasSomeData) {
            return;
        }
        Path oldFile = this.nameToPath(oldName);
        if (PathKt.exists((Path)oldFile)) {
            PathKt.move((Path)oldFile, (Path)this.nameToPath(newName));
        }
    }

    public FileSystemExternalSystemStorage(@NotNull String dirName, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Path path = ExternalProjectsDataStorage.getProjectConfigurationDir(project2).resolve(dirName);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ExternalProjectsDataStor\u2026project).resolve(dirName)");
        this.dir = path;
        BasicFileAttributes fileAttributes = PathKt.basicAttributesIfExists((Path)this.dir);
        if (fileAttributes == null) {
            this.hasSomeData = false;
        } else if (fileAttributes.isRegularFile()) {
            PathKt.deleteChildrenStartingWith((Path)this.dir.getParent(), (String)((Object)this.dir.getFileName()).toString());
            this.hasSomeData = false;
        } else {
            PersistentMapManagerKt.access$getLOG$p().assertTrue(fileAttributes.isDirectory());
            this.hasSomeData = true;
        }
    }
}

