/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationEditor;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRunConfiguration
extends LocatableConfigurationBase
implements SearchScopeProvidingRunProfile {
    public static final Key<InputStream> RUN_INPUT_KEY = Key.create((String)"RUN_INPUT_KEY");
    private static final Logger LOG = Logger.getInstance(ExternalSystemRunConfiguration.class);
    private ExternalSystemTaskExecutionSettings mySettings;

    public ExternalSystemRunConfiguration(@NotNull ProjectSystemId externalSystemId, Project project2, ConfigurationFactory factory, String name2) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "<init>"));
        }
        super(project2, factory, name2);
        this.mySettings = new ExternalSystemTaskExecutionSettings();
        this.mySettings.setExternalSystemIdString(externalSystemId.getId());
    }

    public String suggestedName() {
        return AbstractExternalSystemTaskConfigurationType.generateName(this.getProject(), this.mySettings);
    }

    public ExternalSystemRunConfiguration clone() {
        ExternalSystemRunConfiguration result2 = (ExternalSystemRunConfiguration)super.clone();
        result2.mySettings = this.mySettings.clone();
        return result2;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        Element e = element.getChild("ExternalSystemSettings");
        if (e != null) {
            this.mySettings = (ExternalSystemTaskExecutionSettings)XmlSerializer.deserialize((Element)e, ExternalSystemTaskExecutionSettings.class);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings, (SerializationFilter)new SerializationFilter(){

            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                if (accessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$1", "accepts"));
                }
                if (bean == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$1", "accepts"));
                }
                switch (accessor.getName()) {
                    case "passParentEnvs": {
                        return !ExternalSystemRunConfiguration.this.mySettings.isPassParentEnvs();
                    }
                    case "env": {
                        return !ExternalSystemRunConfiguration.this.mySettings.getEnv().isEmpty();
                    }
                }
                return true;
            }
        }));
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.mySettings;
        if (externalSystemTaskExecutionSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getSettings"));
        }
        return externalSystemTaskExecutionSettings;
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ExternalSystemRunConfigurationEditor(this.getProject(), this.mySettings.getExternalSystemId()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getState"));
        }
        MyRunnableState runnableState = new MyRunnableState(this.mySettings, this.getProject(), DefaultDebugExecutor.EXECUTOR_ID.equals(executor.getId()), this, env);
        this.copyUserDataTo(runnableState);
        return runnableState;
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        VirtualFile file2;
        GlobalSearchScope scope = null;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySettings.getExternalSystemId());
        if (manager != null) {
            scope = manager.getSearchScope(this.getProject(), this.mySettings);
        }
        if (scope == null && (file2 = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getExternalProjectPath()), (boolean)false)) != null) {
            Module module2 = DirectoryIndex.getInstance(this.getProject()).getInfoForFile(file2).getModule();
            scope = SearchScopeProvider.createSearchScope((Module[])((Module[])ContainerUtil.ar((Object[])new Module[]{module2})));
        }
        return scope;
    }

    @NotNull
    private static ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> getConsoleManagerFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConsoleManagerFor"));
        }
        for (ExternalSystemExecutionConsoleManager executionConsoleManager : (ExternalSystemExecutionConsoleManager[])ExternalSystemExecutionConsoleManager.EP_NAME.getExtensions()) {
            if (!executionConsoleManager.isApplicableFor(task)) continue;
            ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager = executionConsoleManager;
            if (externalSystemExecutionConsoleManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConsoleManagerFor"));
            }
            return externalSystemExecutionConsoleManager;
        }
        DefaultExternalSystemExecutionConsoleManager defaultExternalSystemExecutionConsoleManager = new DefaultExternalSystemExecutionConsoleManager();
        if (defaultExternalSystemExecutionConsoleManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration", "getConsoleManagerFor"));
        }
        return defaultExternalSystemExecutionConsoleManager;
    }

    private static class MyProcessHandler
    extends ProcessHandler
    implements AnsiEscapeDecoder.ColoredTextAcceptor {
        private final ExternalSystemExecuteTaskTask myTask;
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        @Nullable
        private OutputStream myProcessInput;

        public MyProcessHandler(ExternalSystemExecuteTaskTask task) {
            this.myTask = task;
            try {
                PipedInputStream inputStream = new PipedInputStream();
                this.myProcessInput = new PipedOutputStream(inputStream);
                task.putUserData(RUN_INPUT_KEY, inputStream);
            }
            catch (IOException e) {
                LOG.warn("Unable to setup process input", (Throwable)e);
            }
        }

        public void notifyTextAvailable(String text2, Key outputType) {
            this.myAnsiEscapeDecoder.escapeText(text2, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
        }

        protected void destroyProcessImpl() {
            this.myTask.cancel(new ExternalSystemTaskNotificationListener[0]);
            this.closeInput();
        }

        protected void detachProcessImpl() {
            this.notifyProcessDetached();
            this.closeInput();
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcessInput;
        }

        public void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
            this.closeInput();
        }

        public void coloredTextAvailable(@NotNull String text2, @NotNull Key attributes) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyProcessHandler", "coloredTextAvailable"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyProcessHandler", "coloredTextAvailable"));
            }
            super.notifyTextAvailable(text2, attributes);
        }

        private void closeInput() {
            StreamUtil.closeStream((Closeable)this.myProcessInput);
            this.myProcessInput = null;
        }
    }

    public static class MyRunnableState
    extends UserDataHolderBase
    implements RunProfileState {
        @NotNull
        private final ExternalSystemTaskExecutionSettings mySettings;
        @NotNull
        private final Project myProject;
        @NotNull
        private final ExternalSystemRunConfiguration myConfiguration;
        @NotNull
        private final ExecutionEnvironment myEnv;
        private final int myDebugPort;

        public MyRunnableState(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull Project project2, boolean debug, @NotNull ExternalSystemRunConfiguration configuration, @NotNull ExecutionEnvironment env) {
            int port;
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "<init>"));
            }
            this.mySettings = settings;
            this.myProject = project2;
            this.myConfiguration = configuration;
            this.myEnv = env;
            if (debug) {
                try {
                    port = NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected I/O exception occurred on attempt to find a free port to use for external system task debugging", (Throwable)e);
                    port = 0;
                }
            } else {
                port = 0;
            }
            this.myDebugPort = port;
        }

        public int getDebugPort() {
            return this.myDebugPort;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState", "execute"));
            }
            if (this.myProject.isDisposed()) {
                return null;
            }
            if (this.mySettings.getTaskNames().isEmpty()) {
                throw new ExecutionException(ExternalSystemBundle.message((String)"run.error.undefined.task", (Object[])new Object[0]));
            }
            String jvmAgentSetup = null;
            if (this.myDebugPort > 0) {
                jvmAgentSetup = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + this.myDebugPort;
            } else {
                ParametersList parametersList = (ParametersList)this.myEnv.getUserData(ExternalSystemTaskExecutionSettings.JVM_AGENT_SETUP_KEY);
                if (parametersList != null) {
                    for (String parameter : parametersList.getList()) {
                        if (parameter.startsWith("-agentlib:") || parameter.startsWith("-agentpath:") || parameter.startsWith("-javaagent:")) continue;
                        throw new ExecutionException(ExternalSystemBundle.message((String)"run.invalid.jvm.agent.configuration", (Object[])new Object[]{parameter}));
                    }
                    jvmAgentSetup = parametersList.getParametersString();
                }
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            FileDocumentManager.getInstance().saveAllDocuments();
            ExternalSystemExecuteTaskTask task = new ExternalSystemExecuteTaskTask(this.myProject, this.mySettings, jvmAgentSetup);
            this.copyUserDataTo(task);
            final MyProcessHandler processHandler2 = new MyProcessHandler(task);
            final ExternalSystemExecutionConsoleManager consoleManager = ExternalSystemRunConfiguration.getConsoleManagerFor(task);
            final ExecutionConsole consoleView = consoleManager.attachExecutionConsole((ExternalSystemTask)task, this.myProject, (RunConfiguration)this.myConfiguration, executor, this.myEnv, (ProcessHandler)processHandler2);
            Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String startDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                String greeting = this.mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.starting.multiple.task", (Object[])new Object[]{startDateTime, this.mySettings.toString()}) : ExternalSystemBundle.message((String)"run.text.starting.single.task", (Object[])new Object[]{startDateTime, this.mySettings.toString()});
                processHandler2.notifyTextAvailable(greeting, ProcessOutputTypes.SYSTEM);
                MyRunnableState.foldGreetingOrFarewell(consoleView, greeting, true);
                ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){
                    private boolean myResetGreeting = true;

                    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text2, boolean stdOut) {
                        if (id == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1", "onTaskOutput"));
                        }
                        if (text2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1", "onTaskOutput"));
                        }
                        if (this.myResetGreeting) {
                            processHandler2.notifyTextAvailable("\r", ProcessOutputTypes.SYSTEM);
                            this.myResetGreeting = false;
                        }
                        consoleManager.onOutput(consoleView, (ProcessHandler)processHandler2, text2, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                    }

                    public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                        if (id == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1", "onFailure"));
                        }
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1", "onFailure"));
                        }
                        String exceptionMessage = ExceptionUtil.getMessage((Throwable)e);
                        String text2 = exceptionMessage == null ? e.toString() : exceptionMessage;
                        processHandler2.notifyTextAvailable(text2 + '\n', ProcessOutputTypes.STDERR);
                        processHandler2.notifyProcessTerminated(1);
                    }

                    public void onEnd(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration$MyRunnableState$1", "onEnd"));
                        }
                        String endDateTime = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                        String farewell = mySettings.getTaskNames().size() > 1 ? ExternalSystemBundle.message((String)"run.text.ended.multiple.task", (Object[])new Object[]{endDateTime, mySettings.toString()}) : ExternalSystemBundle.message((String)"run.text.ended.single.task", (Object[])new Object[]{endDateTime, mySettings.toString()});
                        processHandler2.notifyTextAvailable(farewell, ProcessOutputTypes.SYSTEM);
                        MyRunnableState.foldGreetingOrFarewell(consoleView, farewell, false);
                        processHandler2.notifyProcessTerminated(0);
                    }
                };
                task.execute((ExternalSystemTaskNotificationListener[])ArrayUtil.prepend((Object)taskListener, (Object[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions()));
            });
            DefaultExecutionResult result2 = new DefaultExecutionResult(consoleView, (ProcessHandler)processHandler2);
            result2.setRestartActions(consoleManager.getRestartActions(consoleView));
            return result2;
        }

        private static void foldGreetingOrFarewell(ExecutionConsole consoleView, String text2, boolean isGreeting) {
            DuplexConsoleView duplexConsoleView;
            int limit = 100;
            if (text2.length() < limit) {
                return;
            }
            ConsoleViewImpl consoleViewImpl = consoleView instanceof ConsoleViewImpl ? (ConsoleViewImpl)consoleView : (consoleView instanceof DuplexConsoleView ? ((duplexConsoleView = (DuplexConsoleView)consoleView).getPrimaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getPrimaryConsoleView() : (duplexConsoleView.getSecondaryConsoleView() instanceof ConsoleViewImpl ? (ConsoleViewImpl)duplexConsoleView.getSecondaryConsoleView() : null)) : null);
            if (consoleViewImpl != null) {
                consoleViewImpl.performWhenNoDeferredOutput(() -> {
                    int line;
                    if (!ApplicationManager.getApplication().isDispatchThread()) {
                        return;
                    }
                    Document document = consoleViewImpl.getEditor().getDocument();
                    int n = line = isGreeting ? 0 : document.getLineCount() - 2;
                    if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(line), (CharSequence)text2)) {
                        FoldingModel foldingModel = consoleViewImpl.getEditor().getFoldingModel();
                        foldingModel.runBatchFoldingOperation(() -> {
                            FoldRegion region = foldingModel.addFoldRegion(document.getLineStartOffset(line), document.getLineEndOffset(line), StringUtil.trimLog((String)text2, (int)limit));
                            if (region != null) {
                                region.setExpanded(false);
                            }
                        });
                    }
                });
            }
        }
    }
}

