/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileChooserUtil {
    private static final String LAST_OPENED_FILE_PATH = "last_opened_file_path";

    @Nullable
    public static VirtualFile getLastOpenedFile(@Nullable Project project2) {
        String path;
        if (project2 != null && (path = PropertiesComponent.getInstance((Project)project2).getValue(LAST_OPENED_FILE_PATH)) != null) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public static void setLastOpenedFile(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 != null && !project2.isDisposed() && file2 != null) {
            PropertiesComponent.getInstance((Project)project2).setValue(LAST_OPENED_FILE_PATH, file2.getPath());
        }
    }

    @Nullable
    public static VirtualFile getFileToSelect(@NotNull FileChooserDescriptor descriptor, @Nullable Project project2, @Nullable VirtualFile toSelect2, @Nullable VirtualFile lastPath) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserUtil", "getFileToSelect"));
        }
        boolean chooseDir = descriptor instanceof FileSaverDescriptor;
        VirtualFile result2 = toSelect2 == null && lastPath == null ? (project2 == null ? null : project2.getBaseDir()) : (toSelect2 != null && lastPath != null ? (Boolean.TRUE.equals(descriptor.getUserData(PathChooserDialog.PREFER_LAST_OVER_EXPLICIT)) ? lastPath : toSelect2) : (toSelect2 == null ? lastPath : toSelect2));
        if (result2 != null) {
            if (chooseDir && !result2.isDirectory()) {
                result2 = result2.getParent();
            }
        } else if (SystemInfo.isUnix) {
            result2 = VfsUtil.getUserHomeDir();
        }
        return result2;
    }

    @NotNull
    public static List<VirtualFile> getChosenFiles(@NotNull FileChooserDescriptor descriptor, @NotNull List<VirtualFile> selectedFiles) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserUtil", "getChosenFiles"));
        }
        if (selectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFiles", "com/intellij/openapi/fileChooser/impl/FileChooserUtil", "getChosenFiles"));
        }
        List list2 = ContainerUtil.mapNotNull(selectedFiles, (Function)((NullableFunction)file2 -> {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/FileChooserUtil", "lambda$getChosenFiles$0"));
            }
            return file2 != null && file2.isValid() ? descriptor.getFileToSelect(file2) : null;
        }));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileChooserUtil", "getChosenFiles"));
        }
        return list2;
    }
}

