/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="editorHistoryManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class EditorHistoryManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EditorHistoryManager.class);
    private final Project myProject;
    private final List<HistoryEntry> myEntriesList;

    public static EditorHistoryManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "getInstance"));
        }
        return (EditorHistoryManager)project2.getComponent(EditorHistoryManager.class);
    }

    EditorHistoryManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "<init>"));
        }
        this.myEntriesList = new ArrayList<HistoryEntry>();
        this.myProject = project2;
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.trimToSize());
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before.Adapter(){

            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$1", "beforeFileClosed"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$1", "beforeFileClosed"));
                }
                EditorHistoryManager.this.updateHistoryEntry(file2, false);
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyEditorManagerListener());
    }

    private synchronized void addEntry(HistoryEntry entry) {
        this.myEntriesList.add(entry);
    }

    private synchronized void removeEntry(HistoryEntry entry) {
        boolean removed = this.myEntriesList.remove(entry);
        if (removed) {
            entry.destroy();
        }
    }

    private synchronized void moveOnTop(HistoryEntry entry) {
        this.myEntriesList.remove(entry);
        this.myEntriesList.add(entry);
    }

    private void fileOpenedImpl(@NotNull VirtualFile file2, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider) {
        FileEditor selectedEditor;
        FileEditorProvider[] oldProviders;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "fileOpenedImpl"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (VirtualFileManager.getInstance().findFileByUrl(file2.getUrl()) == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
        Object[] editors = (FileEditor[])editorsWithProviders.getFirst();
        LOG.assertTrue(editors.length == (oldProviders = (FileEditorProvider[])editorsWithProviders.getSecond()).length, (Object)"Different number of editors and providers");
        if (editors.length <= 0 && fallbackEditor != null && fallbackProvider != null) {
            editors = new FileEditor[]{fallbackEditor};
            oldProviders = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors.length <= 0) {
            LOG.error("No editors for file " + file2.getPresentableUrl());
        }
        if ((selectedEditor = editorManager.getSelectedEditor(file2)) == null) {
            selectedEditor = fallbackEditor;
        }
        LOG.assertTrue(selectedEditor != null);
        int selectedProviderIndex = ArrayUtilRt.find((Object[])editors, (Object)selectedEditor);
        LOG.assertTrue(selectedProviderIndex != -1, (Object)("Can't find " + selectedEditor + " among " + Arrays.asList(editors)));
        HistoryEntry entry = this.getEntry(file2);
        if (entry != null) {
            this.moveOnTop(entry);
        } else {
            FileEditorState[] states = new FileEditorState[editors.length];
            FileEditorProvider[] providers2 = new FileEditorProvider[editors.length];
            for (int i = states.length - 1; i >= 0; --i) {
                FileEditorProvider provider = oldProviders[i];
                LOG.assertTrue(provider != null);
                providers2[i] = provider;
                Object editor = editors[i];
                if (!editor.isValid()) continue;
                states[i] = editor.getState(FileEditorStateLevel.FULL);
            }
            this.addEntry(HistoryEntry.createHeavy(this.myProject, file2, providers2, states, providers2[selectedProviderIndex]));
            this.trimToSize();
        }
    }

    public void updateHistoryEntry(@Nullable VirtualFile file2, boolean changeEntryOrderOnly) {
        this.updateHistoryEntry(file2, null, null, changeEntryOrderOnly);
    }

    private void updateHistoryEntry(@Nullable VirtualFile file2, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider, boolean changeEntryOrderOnly) {
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider;
        if (file2 == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
        FileEditor[] editors = (FileEditor[])editorsWithProviders.getFirst();
        FileEditorProvider[] providers2 = (FileEditorProvider[])editorsWithProviders.getSecond();
        if (editors.length <= 0 && fallbackEditor != null) {
            editors = new FileEditor[]{fallbackEditor};
            providers2 = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors.length == 0) {
            return;
        }
        HistoryEntry entry = this.getEntry(file2);
        if (entry == null) {
            if (file2.isValid()) {
                this.fileOpenedImpl(file2, fallbackEditor, fallbackProvider);
            }
            return;
        }
        if (!changeEntryOrderOnly) {
            for (int i = editors.length - 1; i >= 0; --i) {
                FileEditor editor = editors[i];
                FileEditorProvider provider = providers2[i];
                if (provider == null || !editor.isValid()) continue;
                FileEditorState oldState = entry.getState(provider);
                FileEditorState newState = editor.getState(FileEditorStateLevel.FULL);
                if (newState.equals(oldState)) continue;
                entry.putState(provider, newState);
            }
        }
        if ((selectedEditorWithProvider = editorManager.getSelectedEditorWithProvider(file2)) != null) {
            entry.setSelectedProvider((FileEditorProvider)selectedEditorWithProvider.getSecond());
            LOG.assertTrue(entry.getSelectedProvider() != null);
            if (changeEntryOrderOnly) {
                this.moveOnTop(entry);
            }
        }
    }

    public synchronized VirtualFile[] getFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.myEntriesList.size());
        for (HistoryEntry entry : this.myEntriesList) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public LinkedHashSet<VirtualFile> getFileSet() {
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (VirtualFile file2 : this.getFiles()) {
            result2.remove(file2);
            result2.add(file2);
        }
        return result2;
    }

    public synchronized boolean hasBeenOpen(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "hasBeenOpen"));
        }
        for (HistoryEntry each : this.myEntriesList) {
            if (!Comparing.equal((Object)each.getFile(), (Object)f)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "removeFile"));
        }
        HistoryEntry entry = this.getEntry(file2);
        if (entry != null) {
            this.removeEntry(entry);
        }
    }

    public FileEditorState getState(@NotNull VirtualFile file2, FileEditorProvider provider) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "getState"));
        }
        HistoryEntry entry = this.getEntry(file2);
        return entry != null ? entry.getState(provider) : null;
    }

    public FileEditorProvider getSelectedProvider(VirtualFile file2) {
        HistoryEntry entry = this.getEntry(file2);
        return entry != null ? entry.getSelectedProvider() : null;
    }

    private synchronized HistoryEntry getEntry(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "getEntry"));
        }
        for (int i = this.myEntriesList.size() - 1; i >= 0; --i) {
            HistoryEntry entry = this.myEntriesList.get(i);
            VirtualFile entryFile = entry.getFile();
            if (!file2.equals(entryFile)) continue;
            return entry;
        }
        return null;
    }

    private synchronized void trimToSize() {
        int limit = UISettings.getInstance().getRecentFilesLimit() + 1;
        while (this.myEntriesList.size() > limit) {
            HistoryEntry removed = this.myEntriesList.remove(0);
            removed.destroy();
        }
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager", "loadState"));
        }
        Element state = element.clone();
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            for (Element e : state.getChildren("entry")) {
                try {
                    this.addEntry(HistoryEntry.createHeavy(this.myProject, e));
                }
                catch (ProcessCanceledException | InvalidDataException throwable) {
                }
                catch (Exception anyException) {
                    LOG.error((Throwable)anyException);
                }
            }
            this.trimToSize();
        }));
    }

    public synchronized Element getState() {
        Element element = new Element("state");
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
        for (int i = openFiles.length - 1; i >= 0; --i) {
            VirtualFile file2 = openFiles[i];
            if (this.getEntry(file2) == null) continue;
            this.updateHistoryEntry(file2, false);
        }
        for (HistoryEntry entry : this.myEntriesList) {
            entry.writeExternal(element, this.myProject);
        }
        return element;
    }

    public synchronized void dispose() {
        for (HistoryEntry entry : this.myEntriesList) {
            entry.destroy();
        }
        this.myEntriesList.clear();
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener", "fileOpened"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener", "fileOpened"));
            }
            EditorHistoryManager.this.fileOpenedImpl(file2, null, null);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener", "selectionChanged"));
            }
            PsiDocumentManager.getInstance((Project)EditorHistoryManager.this.myProject).performWhenAllCommitted(() -> {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener", "lambda$selectionChanged$0"));
                }
                FileEditor newEditor = event.getNewEditor();
                if (newEditor != null && !newEditor.isValid()) {
                    return;
                }
                EditorHistoryManager.this.updateHistoryEntry(event.getOldFile(), event.getOldEditor(), event.getOldProvider(), false);
                EditorHistoryManager.this.updateHistoryEntry(event.getNewFile(), true);
            });
        }
    }
}

