/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameBuilderCacheKey = Key.create((String)"project's.short.file.name.builder");
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameOpenedBuilderCacheKey = Key.create((String)"project's.short.file.name.opened.builder");
    private static final UniqueNameBuilder<VirtualFile> ourEmptyBuilder = new UniqueNameBuilder(null, null, -1);

    @NotNull
    public String getUniqueVirtualFilePath(Project project2, VirtualFile file2, GlobalSearchScope scope) {
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project2, file2, false, scope);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePath"));
        }
        return string;
    }

    public String getUniqueVirtualFilePath(Project project2, VirtualFile vFile) {
        return this.getUniqueVirtualFilePath(project2, vFile, GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(Project project2, VirtualFile vFile) {
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project2, vFile, true, GlobalSearchScope.projectScope((Project)project2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePathWithinOpenedFileEditors"));
        }
        return string;
    }

    private static String getUniqueVirtualFilePath(Project project2, VirtualFile file2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        String fileName;
        UniqueNameBuilder<VirtualFile> uniqueNameBuilderForShortName;
        ConcurrentMap scope2ValueMap;
        Map valueMap;
        Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> key2 = skipNonOpenedFiles ? ourShortNameOpenedBuilderCacheKey : ourShortNameBuilderCacheKey;
        CachedValue data = (CachedValue)project2.getUserData(key2);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> new CachedValueProvider.Result(new ConcurrentHashMap(2), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FileEditorManagerImpl.OPEN_FILE_SET_MODIFICATION_COUNT}), false);
            project2.putUserData(key2, (Object)data);
        }
        if ((valueMap = (Map)(scope2ValueMap = (ConcurrentMap)data.getValue()).get(scope)) == null) {
            valueMap = (Map)ConcurrencyUtil.cacheOrGet((ConcurrentMap)scope2ValueMap, (Object)scope, (Object)ContainerUtil.createConcurrentSoftValueMap());
        }
        if ((uniqueNameBuilderForShortName = (UniqueNameBuilder<VirtualFile>)valueMap.get(fileName = file2.getName())) == null) {
            UniqueNameBuilder<VirtualFile> builder = UniqueVFilePathBuilderImpl.filesWithTheSameName(fileName, project2, skipNonOpenedFiles, scope);
            valueMap.put(fileName, builder != null ? builder : ourEmptyBuilder);
            uniqueNameBuilderForShortName = builder;
        } else if (uniqueNameBuilderForShortName == ourEmptyBuilder) {
            uniqueNameBuilderForShortName = null;
        }
        if (uniqueNameBuilderForShortName != null && uniqueNameBuilderForShortName.contains((Object)file2)) {
            if (file2 instanceof VirtualFilePathWrapper) {
                return ((VirtualFilePathWrapper)file2).getPresentablePath();
            }
            return uniqueNameBuilderForShortName.getShortPath((Object)file2);
        }
        return file2.getName();
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> filesWithTheSameName(String fileName, Project project2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        THashSet filesWithSameName = skipNonOpenedFiles ? Collections.emptySet() : FilenameIndex.getVirtualFilesByName(project2, fileName, scope);
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile2 : FileEditorManager.getInstance((Project)project2).getOpenFiles()) {
            if (!openFile2.getName().equals(fileName)) continue;
            setOfFilesWithTheSameName.add((Object)openFile2);
        }
        if (!skipNonOpenedFiles) {
            for (VirtualFile recentlyEditedFile : EditorHistoryManager.getInstance(project2).getFiles()) {
                if (!recentlyEditedFile.getName().equals(fileName)) continue;
                setOfFilesWithTheSameName.add((Object)recentlyEditedFile);
            }
        }
        if ((filesWithSameName = setOfFilesWithTheSameName).size() > 1) {
            String path = project2.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                builder.addPath((Object)virtualFile, virtualFile.getPath());
            }
            return builder;
        }
        return null;
    }
}

