/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeChooser
extends DialogWrapper {
    private JList<FileType> myList;
    private JLabel myTitleLabel;
    private ComboBox<String> myPattern;
    private JPanel myPanel;
    private JRadioButton myOpenInIdea;
    private JRadioButton myOpenAsNative;
    private final String myFileName;

    private FileTypeChooser(@NotNull List<String> patterns, @NotNull String fileName) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "<init>"));
        }
        super(true);
        this.myFileName = fileName;
        this.$$$setupUI$$$();
        this.myOpenInIdea.setText(FileTypesBundle.message("filetype.chooser.association", ApplicationNamesInfo.getInstance().getFullProductName()));
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Arrays.sort(fileTypes, (ft1, ft2) -> ft1 == null ? 1 : (ft2 == null ? -1 : ft1.getDescription().compareToIgnoreCase(ft2.getDescription())));
        DefaultListModel<FileType> model = new DefaultListModel<FileType>();
        for (FileType type2 : fileTypes) {
            if (type2.isReadOnly() || type2 == FileTypes.UNKNOWN || type2 instanceof NativeFileType) continue;
            model.addElement(type2);
        }
        this.myList.setModel(model);
        this.myPattern.setModel((ComboBoxModel)new CollectionComboBoxModel(ContainerUtil.map(patterns, (Function)FunctionUtil.id()), (Object)patterns.get(0)));
        new ListSpeedSearch<FileType>(this.myList, o -> ((FileType)o).getName());
        this.setTitle(FileTypesBundle.message("filetype.chooser.title", new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myTitleLabel.setText(FileTypesBundle.message("filetype.chooser.prompt", this.myFileName));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer<FileType>)((Object)new FileTypeRenderer()));
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                FileTypeChooser.this.doOKAction();
                return true;
            }
        }.installOn(this.myList);
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileTypeChooser.this.updateButtonsState();
            }
        });
        ScrollingUtil.selectItem(this.myList, (Object)FileTypes.PLAIN_TEXT);
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    private void updateButtonsState() {
        this.setOKActionEnabled(this.myList.getSelectedIndex() != -1 || this.myOpenAsNative.isSelected());
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.fileTypes.FileTypeChooser";
    }

    public FileType getSelectedType() {
        return this.myOpenAsNative.isSelected() ? NativeFileType.INSTANCE : this.myList.getSelectedValue();
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file2, @Nullable Project project2) {
        FileType type2;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "getKnownFileTypeOrAssociate"));
        }
        if (project2 != null && !(file2 instanceof FakeVirtualFile)) {
            PsiManagerEx.getInstanceEx(project2).getFileManager().findFile(file2);
        }
        if ((type2 = file2.getFileType()) == FileTypes.UNKNOWN) {
            type2 = FileTypeChooser.getKnownFileTypeOrAssociate(file2.getName());
        }
        return type2;
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile parent, @NotNull String newName, @Nullable Project project2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "getKnownFileTypeOrAssociate"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "getKnownFileTypeOrAssociate"));
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)new FakeVirtualFile(parent, newName), project2);
    }

    @Nullable
    public static FileType getKnownFileTypeOrAssociate(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "getKnownFileTypeOrAssociate"));
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType type2 = fileTypeManager.getFileTypeByFileName(fileName);
        if (type2 == FileTypes.UNKNOWN) {
            type2 = FileTypeChooser.associateFileType(fileName);
        }
        return type2;
    }

    @Nullable
    public static FileType associateFileType(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "associateFileType"));
        }
        FileTypeChooser chooser = new FileTypeChooser(FileTypeChooser.suggestPatterns(fileName), fileName);
        if (!chooser.showAndGet()) {
            return null;
        }
        FileType type2 = chooser.getSelectedType();
        if (type2 == FileTypes.UNKNOWN || type2 == null) {
            return null;
        }
        ApplicationManager.getApplication().runWriteAction(() -> FileTypeManagerEx.getInstanceEx().associatePattern(type2, (String)chooser.myPattern.getSelectedItem()));
        return type2;
    }

    @NotNull
    static List<String> suggestPatterns(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "suggestPatterns"));
        }
        LinkedList patterns = ContainerUtil.newLinkedList((Object[])new String[]{fileName});
        int i2 = -1;
        while ((i2 = fileName.indexOf(46, i2 + 1)) > 0) {
            String extension = fileName.substring(i2);
            if (StringUtil.isEmpty((String)extension)) continue;
            patterns.add(0, "*" + extension);
        }
        LinkedList linkedList = patterns;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/ex/FileTypeChooser", "suggestPatterns"));
        }
        return linkedList;
    }

    protected String getHelpId() {
        return "reference.dialogs.register.association";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JBList jBList;
        ComboBox comboBox;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTitleLabel = jLabel = new JLabel();
        jLabel.setText("Cannot associate _template_");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetype.chooser.file.pattern"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPattern = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 0, 3, 7, 7, null, new Dimension(150, 200), null, 2));
        this.myList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        this.myOpenInIdea = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Open matching files in PRODUCTNAME as type:");
        jRadioButton2.setSelected(true);
        jPanel.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOpenAsNative = jRadioButton = new JRadioButton();
        jRadioButton.setText("Open matching files in associated application");
        jPanel.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

