/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.KeymapScheme;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.ui.MessageType;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeymapSelector
extends SimpleSchemesPanel<KeymapScheme> {
    private KeymapSchemeManager manager;
    private final Consumer<Keymap> consumer;
    private String messageReplacement;
    private boolean messageShown;
    private boolean internal;

    KeymapSelector(Consumer<Keymap> consumer) {
        super(0);
        this.consumer = consumer;
    }

    public KeymapSchemeManager getManager() {
        if (this.manager == null) {
            this.manager = new KeymapSchemeManager(this);
        }
        return this.manager;
    }

    @Override
    @NotNull
    public SchemesModel<KeymapScheme> getModel() {
        KeymapSchemeManager keymapSchemeManager = this.getManager();
        if (keymapSchemeManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/KeymapSelector", "getModel"));
        }
        return keymapSchemeManager;
    }

    @Override
    @Nullable
    protected String getComboBoxLabel() {
        return null;
    }

    @Override
    protected String getSchemeTypeName() {
        return "Keymap";
    }

    @Override
    protected AbstractSchemeActions<KeymapScheme> createSchemeActions() {
        return this.getManager();
    }

    @Override
    protected int getIndent(@NotNull KeymapScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/keymap/impl/ui/KeymapSelector", "getIndent"));
        }
        return scheme2.isMutable() ? 1 : 0;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Override
    public void showMessage(@Nullable String message2, @NotNull MessageType messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/intellij/openapi/keymap/impl/ui/KeymapSelector", "showMessage"));
        }
        this.messageShown = true;
        super.showMessage(message2, messageType);
    }

    @Override
    public void clearMessage() {
        this.messageShown = false;
        super.showMessage(this.messageReplacement, MessageType.INFO);
    }

    void notifyConsumer(KeymapScheme scheme2) {
        if (this.internal) {
            return;
        }
        Keymap keymap = scheme2 == null ? null : scheme2.getParent();
        String string = this.messageReplacement = keymap == null ? null : KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{keymap.getPresentableName()});
        if (!this.messageShown) {
            this.clearMessage();
        }
        this.consumer.accept(scheme2 == null ? null : scheme2.getCurrent());
    }

    void selectKeymap(KeymapScheme scheme2, boolean reset) {
        try {
            this.internal = true;
            if (reset) {
                this.resetSchemes(this.getManager().getSchemes());
            }
            if (scheme2 != null) {
                this.selectScheme(scheme2);
            }
        }
        finally {
            this.internal = false;
            this.notifyConsumer((KeymapScheme)this.getSelectedScheme());
        }
    }
}

