/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebModuleBuilder<T>
extends ModuleBuilder {
    public static final String GROUP_NAME = "Static Web";
    public static final Icon ICON = AllIcons.Nodes.PpWeb;
    private final WebProjectTemplate<T> myTemplate;
    private final ProjectGeneratorPeer<T> myGeneratorPeer;

    public WebModuleBuilder(@NotNull WebProjectTemplate<T> template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/openapi/module/WebModuleBuilder", "<init>"));
        }
        this.myTemplate = template;
        this.myGeneratorPeer = (ProjectGeneratorPeer)this.myTemplate.createLazyPeer().getValue();
    }

    public WebModuleBuilder() {
        this.myTemplate = null;
        this.myGeneratorPeer = null;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        this.doAddContentEntry(modifiableRootModel);
    }

    public ModuleType getModuleType() {
        return WebModuleType.getInstance();
    }

    public String getPresentableName() {
        return this.getGroupName();
    }

    public boolean isTemplateBased() {
        return true;
    }

    public String getGroupName() {
        return GROUP_NAME;
    }

    public Icon getNodeIcon() {
        return this.myTemplate != null ? this.myTemplate.getIcon() : ICON;
    }

    @Nullable
    public Module commitModule(@NotNull Project project2, @Nullable ModifiableModuleModel model) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/WebModuleBuilder", "commitModule"));
        }
        Module module2 = super.commitModule(project2, model);
        if (module2 != null && this.myTemplate != null) {
            this.doGenerate(this.myTemplate, module2);
        }
        return module2;
    }

    private void doGenerate(@NotNull WebProjectTemplate<T> template, @NotNull Module module2) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/openapi/module/WebModuleBuilder", "doGenerate"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/WebModuleBuilder", "doGenerate"));
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
        VirtualFile dir = module2.getProject().getBaseDir();
        if (contentRoots.length > 0 && contentRoots[0] != null) {
            dir = contentRoots[0];
        }
        template.generateProject(module2.getProject(), dir, this.myGeneratorPeer.getSettings(), module2);
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/openapi/module/WebModuleBuilder", "modifySettingsStep"));
        }
        if (this.myTemplate == null) {
            return super.modifySettingsStep(settingsStep);
        }
        this.myGeneratorPeer.buildUI(settingsStep);
        return new ModuleWizardStep(){

            public JComponent getComponent() {
                return null;
            }

            public void updateDataModel() {
            }

            public boolean validate() throws ConfigurationException {
                ValidationInfo info = WebModuleBuilder.this.myGeneratorPeer.validate();
                if (info != null) {
                    throw new ConfigurationException(info.message);
                }
                return true;
            }
        };
    }
}

